"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useResetAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _transform_list = require("../../../../common/transform_list");
var _constants = require("../../../../../../common/constants");
var _hooks = require("../../../../hooks");
var _reset_action_name = require("./reset_action_name");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useResetAction = forceDisable => {
  const {
    canResetTransform
  } = (0, _hooks.useTransformCapabilities)();
  const resetTransforms = (0, _hooks.useResetTransforms)();
  const [isModalVisible, setModalVisible] = (0, _react.useState)(false);
  const [items, setItems] = (0, _react.useState)([]);
  const shouldForceReset = (0, _react.useMemo)(() => items.some(i => {
    var _i$stats;
    return ((_i$stats = i.stats) === null || _i$stats === void 0 ? void 0 : _i$stats.state) === _constants.TRANSFORM_STATE.FAILED;
  }), [items]);
  const closeModal = () => setModalVisible(false);
  const resetAndCloseModal = () => {
    setModalVisible(false);
    resetTransforms({
      transformsInfo: items.filter(_transform_list.isTransformListRowWithStats).map(i => ({
        id: i.config.id,
        state: i.stats.state
      }))
    });
  };
  const openModal = newItems => {
    if (Array.isArray(newItems)) {
      setItems(newItems);
      setModalVisible(true);
    }
  };
  const action = (0, _react.useMemo)(() => ({
    name: item => /*#__PURE__*/_react.default.createElement(_reset_action_name.ResetActionName, {
      canResetTransform,
      disabled: (0, _reset_action_name.isResetActionDisabled)([item], forceDisable),
      isBulkAction: false,
      items: [item]
    }),
    enabled: item => (0, _reset_action_name.getResetActionDisabledMessage)({
      items: [item],
      canResetTransform,
      forceDisable
    }) === undefined,
    description: _reset_action_name.resetActionNameText,
    icon: 'refresh',
    type: 'icon',
    onClick: item => openModal([item]),
    'data-test-subj': 'transformActionReset'
  }), [canResetTransform, forceDisable]);
  return {
    action,
    closeModal,
    resetAndCloseModal,
    isModalVisible,
    items,
    openModal,
    shouldForceReset
  };
};
exports.useResetAction = useResetAction;