"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPercentilesAggConfig = getPercentilesAggConfig;
var _i18n = require("@kbn/i18n");
var _percentiles_form_component = require("./percentiles_form_component");
var _common = require("../../../../../../common");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function validatePercentsInput(config) {
  var _config$percents;
  const allValues = [...((_config$percents = config.percents) !== null && _config$percents !== void 0 ? _config$percents : [])];
  const errors = [];
  // Combine existing percents with pending input for validation
  if (config.pendingPercentileInput) {
    // Replace comma with dot before converting to number
    const normalizedInput = config.pendingPercentileInput.replace(',', '.');
    const pendingValue = Number(normalizedInput);
    if (allValues.includes(pendingValue)) {
      errors.push('DUPLICATE_VALUE');
    }
    if (normalizedInput.replace('.', '').length > _constants.MAX_PERCENTILE_PRECISION) {
      errors.push('NUMBER_TOO_PRECISE');
    }
    allValues.push(pendingValue);
  }
  if (allValues.length === 0) {
    return {
      isValid: false,
      errors: []
    };
  }
  if (allValues.some(value => isNaN(value))) {
    errors.push('INVALID_FORMAT');
  }
  if (allValues.some(value => value < _constants.MIN_PERCENTILE_VALUE || value > _constants.MAX_PERCENTILE_VALUE)) {
    errors.push('PERCENTILE_OUT_OF_RANGE');
  }
  return {
    isValid: errors.length === 0,
    errors: errors.length > 0 ? errors : undefined
  };
}
function getPercentilesAggConfig(commonConfig) {
  const field = (0, _common.isPivotAggsConfigWithUiBase)(commonConfig) ? commonConfig.field : null;
  return {
    ...commonConfig,
    isSubAggsSupported: false,
    isMultiField: false,
    AggFormComponent: _percentiles_form_component.PercentilesAggForm,
    field,
    aggConfig: {
      percents: _common.PERCENTILES_AGG_DEFAULT_PERCENTS
    },
    setUiConfigFromEs(esAggDefinition) {
      const {
        field: esField,
        percents
      } = esAggDefinition;
      this.field = esField;
      this.aggConfig.percents = percents;
    },
    getEsAggConfig() {
      var _this$aggConfig$perce;
      if (!this.isValid()) {
        return null;
      }
      return {
        field: this.field,
        percents: (_this$aggConfig$perce = this.aggConfig.percents) !== null && _this$aggConfig$perce !== void 0 ? _this$aggConfig$perce : []
      };
    },
    isValid() {
      const validationResult = validatePercentsInput(this.aggConfig);
      this.aggConfig.errors = validationResult.errors;
      return validationResult.isValid;
    },
    getErrorMessages() {
      var _this$aggConfig$error;
      if (!((_this$aggConfig$error = this.aggConfig.errors) !== null && _this$aggConfig$error !== void 0 && _this$aggConfig$error.length)) return;
      return this.aggConfig.errors.map(error => ERROR_MESSAGES[error]);
    }
  };
}
const ERROR_MESSAGES = {
  INVALID_FORMAT: _i18n.i18n.translate('xpack.transform.agg.popoverForm.invalidFormatError', {
    defaultMessage: 'Percentile must be a valid number'
  }),
  PERCENTILE_OUT_OF_RANGE: _i18n.i18n.translate('xpack.transform.agg.popoverForm.percentileOutOfRangeError', {
    defaultMessage: 'Percentiles must be between 0 and 100'
  }),
  NUMBER_TOO_PRECISE: _i18n.i18n.translate('xpack.transform.agg.popoverForm.numberTooPreciseError', {
    defaultMessage: 'Value is too precise. Use fewer decimal places.'
  }),
  DUPLICATE_VALUE: _i18n.i18n.translate('xpack.transform.agg.popoverForm.duplicateValueError', {
    defaultMessage: 'Value already exists'
  })
};