"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DropDown = void 0;
var _react = _interopRequireDefault(require("react"));
var _option_list_with_stats = require("@kbn/ml-field-stats-flyout/options_list_with_stats/option_list_with_stats");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DropDown = ({
  renderOption,
  changeHandler,
  options,
  placeholder = 'Search ...',
  testSubj,
  isDisabled
}) => {
  return /*#__PURE__*/_react.default.createElement(_option_list_with_stats.OptionListWithFieldStats, {
    fullWidth: true,
    placeholder: placeholder,
    singleSelection: {
      asPlainText: true
    },
    options: options,
    selectedOptions: [],
    onChange: changeHandler,
    isClearable: false,
    "data-test-subj": testSubj,
    isDisabled: isDisabled
  });
};
exports.DropDown = DropDown;