"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SUCCESS_TOAST_TITLE = exports.COPY_TO_CLIPBOARD = exports.ADD_TO_TIMELINE = exports.ADDED_TO_TIMELINE_OR_TEMPLATE_MESSAGE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ADD_TO_TIMELINE = exports.ADD_TO_TIMELINE = _i18n.i18n.translate('xpack.timelines.hoverActions.addToTimeline', {
  defaultMessage: 'Add to Timeline investigation'
});
const ADDED_TO_TIMELINE_OR_TEMPLATE_MESSAGE = (fieldOrValue, isTimeline) => _i18n.i18n.translate('xpack.timelines.hoverActions.addToTimeline.addedFieldMessage', {
  values: {
    fieldOrValue,
    isTimeline
  },
  defaultMessage: `Added {fieldOrValue} to {isTimeline, select, true {Timeline} other {template}}`
});
exports.ADDED_TO_TIMELINE_OR_TEMPLATE_MESSAGE = ADDED_TO_TIMELINE_OR_TEMPLATE_MESSAGE;
const COPY_TO_CLIPBOARD = exports.COPY_TO_CLIPBOARD = _i18n.i18n.translate('xpack.timelines.dragAndDrop.copyToClipboardTooltip', {
  defaultMessage: 'Copy to clipboard'
});
const SUCCESS_TOAST_TITLE = field => _i18n.i18n.translate('xpack.timelines.clipboard.copy.successToastTitle', {
  values: {
    field
  },
  defaultMessage: 'Copied field {field} to the clipboard'
});
exports.SUCCESS_TOAST_TITLE = SUCCESS_TOAST_TITLE;