"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFilterInOut = void 0;
var _react = require("react");
var _field_value = require("../../indicators/utils/field_value");
var _use_filters_context = require("../../indicators/hooks/use_filters_context");
var _filter = require("../utils/filter");
var _use_sourcerer_data_view = require("../../indicators/hooks/use_sourcerer_data_view");
var _unwrap_value = require("../../indicators/utils/unwrap_value");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Custom hook that uses an indicator, a field and a type (FilterIn or FilterOut) and returns the filter function.
 *
 */
const useFilterInOut = ({
  indicator,
  field,
  filterType
}) => {
  const {
    filterManager
  } = (0, _use_filters_context.useIndicatorsFiltersContext)();
  const {
    sourcererDataView
  } = (0, _use_sourcerer_data_view.useSourcererDataView)();
  const {
    key
  } = typeof indicator === 'string' ? {
    key: field
  } : (0, _field_value.getIndicatorFieldAndValue)(indicator, field);
  const value = typeof indicator === 'string' ? indicator : (0, _unwrap_value.unwrapValue)(indicator, field);
  const filterFn = (0, _react.useCallback)(() => {
    const existingFilters = filterManager.getFilters();
    const newFilters = (0, _filter.updateFiltersArray)(existingFilters, key, value, filterType, sourcererDataView.id);
    filterManager.setFilters(newFilters);
  }, [filterManager, filterType, key, sourcererDataView.id, value]);
  if (!(0, _field_value.fieldAndValueValid)(key, value)) {
    return {};
  }
  return {
    filterFn
  };
};
exports.useFilterInOut = useFilterInOut;