"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorBarchartLegendAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _copy_to_clipboard = require("../common/copy_to_clipboard");
var _filter_in = require("../../../query_bar/components/filter_in");
var _filter_out = require("../../../query_bar/components/filter_out");
var _add_to_timeline = require("../../../timeline/components/add_to_timeline");
var _test_ids = require("./test_ids");
var _translations = require("./translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndicatorBarchartLegendAction = ({
  data,
  field,
  announceIndicatorActionChange
}) => {
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const group = field.value === 'date' ? (0, _moment.default)(data).toISOString() : data;
  const popoverItems = [/*#__PURE__*/_react.default.createElement(_filter_in.FilterInContextMenu, {
    key: _test_ids.FILTER_IN_BUTTON_TEST_ID,
    data: group,
    field: field.label,
    onAnnounce: announceIndicatorActionChange,
    "data-test-subj": _test_ids.FILTER_IN_BUTTON_TEST_ID
  }), /*#__PURE__*/_react.default.createElement(_filter_out.FilterOutContextMenu, {
    key: _test_ids.FILTER_OUT_BUTTON_TEST_ID,
    data: group,
    field: field.label,
    onAnnounce: announceIndicatorActionChange,
    "data-test-subj": _test_ids.FILTER_OUT_BUTTON_TEST_ID
  }), /*#__PURE__*/_react.default.createElement(_add_to_timeline.AddToTimelineContextMenu, {
    key: _test_ids.TIMELINE_BUTTON_TEST_ID,
    data: group,
    field: field.label,
    "data-test-subj": _test_ids.TIMELINE_BUTTON_TEST_ID
  }), /*#__PURE__*/_react.default.createElement(_copy_to_clipboard.CopyToClipboardContextMenu, {
    key: _test_ids.COPY_TO_CLIPBOARD_BUTTON_TEST_ID,
    value: group,
    "data-test-subj": _test_ids.COPY_TO_CLIPBOARD_BUTTON_TEST_ID
  })];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": _test_ids.POPOVER_BUTTON_TEST_ID,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _translations.BUTTON_LABEL
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": _translations.BUTTON_LABEL,
      iconType: "boxesHorizontal",
      iconSize: "s",
      size: "xs",
      onClick: () => setPopover(prevIsPopoverOpen => !prevIsPopoverOpen),
      style: {
        height: '100%'
      }
    })),
    isOpen: isPopoverOpen,
    closePopover: () => setPopover(false),
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: popoverItems
  }));
};
exports.IndicatorBarchartLegendAction = IndicatorBarchartLegendAction;