"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddToBlockListContextMenu = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_security_context = require("../../../hooks/use_security_context");
var _use_block_list_context = require("../../indicators/hooks/use_block_list_context");
var _use_set_url_params = require("../hooks/use_set_url_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Add to blocklist functionality displayed as a ContextMenuItem (in the main indicators table row and in the indicator flyout).
 * The entry is disabled is the filehash isn't sha256, sha1 or md5.
 * When clicking on the ContextMenuItem, the indicator filehash value is saved in context.
 * The flyout is shown by adding a parameter to the url.
 */
const AddToBlockListContextMenu = ({
  data,
  'data-test-subj': dataTestSub,
  onClick
}) => {
  const {
    blockList: {
      canWriteBlocklist
    }
  } = (0, _use_security_context.useSecurityContext)();
  const {
    setBlockListIndicatorValue
  } = (0, _use_block_list_context.useBlockListContext)();
  const {
    setUrlParams
  } = (0, _use_set_url_params.useSetUrlParams)();
  const menuItemClicked = () => {
    onClick();
    setBlockListIndicatorValue(data);
    setUrlParams({
      show: 'create'
    });
  };
  const disabled = !canWriteBlocklist || data === null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "addToBlocklist",
    onClick: () => menuItemClicked(),
    "data-test-subj": dataTestSub,
    disabled: disabled
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Add blocklist entry",
    id: "xpack.threatIntelligence.addToBlockList"
  }));
};
exports.AddToBlockListContextMenu = AddToBlockListContextMenu;