"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.asyncGlobalParamsPropagation = exports.SyncGlobalParamsPrivateLocationsTask = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("@kbn/spaces-plugin/common/constants");
var _uuid = require("uuid");
var _deploy_private_location_monitors = require("./deploy_private_location_monitors");
var _get_private_locations = require("../synthetics_service/get_private_locations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TASK_TYPE = 'Synthetics:Sync-Global-Params-Private-Locations';
class SyncGlobalParamsPrivateLocationsTask {
  constructor(serverSetup, taskManager, syntheticsMonitorClient) {
    (0, _defineProperty2.default)(this, "deployPackagePolicies", void 0);
    (0, _defineProperty2.default)(this, "debugLog", message => {
      this.serverSetup.logger.debug(`[SyncGlobalParamsPrivateLocationsTask] ${message}`);
    });
    this.serverSetup = serverSetup;
    this.taskManager = taskManager;
    this.syntheticsMonitorClient = syntheticsMonitorClient;
    this.deployPackagePolicies = new _deploy_private_location_monitors.DeployPrivateLocationMonitors(serverSetup, syntheticsMonitorClient);
  }
  registerTaskDefinition(taskManager) {
    taskManager.registerTaskDefinitions({
      [TASK_TYPE]: {
        title: 'Synthetics Sync Global Params Task',
        description: 'This task is executed so that we can sync private location monitors for example when global params are updated',
        timeout: '10m',
        maxAttempts: 2,
        createTaskRunner: ({
          taskInstance
        }) => {
          return {
            run: async () => {
              return this.runTask({
                taskInstance
              });
            }
          };
        }
      }
    });
  }
  async runTask({
    taskInstance
  }) {
    const {
      coreStart: {
        savedObjects
      },
      encryptedSavedObjects,
      logger
    } = this.serverSetup;
    const paramsSpaceToSync = taskInstance.state.paramsSpaceToSync;
    if (paramsSpaceToSync) {
      try {
        this.debugLog(`current task state is ${JSON.stringify(taskInstance.state)}`);
        const soClient = savedObjects.createInternalRepository();
        const allPrivateLocations = await (0, _get_private_locations.getPrivateLocations)(soClient, _constants.ALL_SPACES_ID);
        if (allPrivateLocations.length > 0) {
          await this.deployPackagePolicies.syncPackagePolicies({
            allPrivateLocations,
            soClient,
            encryptedSavedObjects,
            spaceIdToSync: paramsSpaceToSync
          });
          this.debugLog(`Sync of global params succeeded for space  ${paramsSpaceToSync}`);
        }
      } catch (error) {
        logger.error(`Sync of global params failed: ${error.message}`);
        return {
          error,
          state: {
            paramsSpaceToSync
          }
        };
      }
    }
  }
}
exports.SyncGlobalParamsPrivateLocationsTask = SyncGlobalParamsPrivateLocationsTask;
const asyncGlobalParamsPropagation = async ({
  server,
  paramsSpacesToSync
}) => {
  const {
    pluginsStart: {
      taskManager
    }
  } = server;
  const spacesToUpdate = paramsSpacesToSync.includes(_constants.ALL_SPACES_ID) ? [_constants.ALL_SPACES_ID] : paramsSpacesToSync;
  await Promise.all(spacesToUpdate.map(async spaceId => {
    await taskManager.ensureScheduled({
      id: `${TASK_TYPE}:${(0, _uuid.v4)()}`,
      params: {},
      taskType: TASK_TYPE,
      runAt: new Date(Date.now() + 3 * 1000),
      state: {
        paramsSpaceToSync: spaceId
      }
    });
  }));
};
exports.asyncGlobalParamsPropagation = asyncGlobalParamsPropagation;