"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.syncParamsSyntheticsParamsRoute = void 0;
var _sync_global_params_task = require("../../../tasks/sync_global_params_task");
var _constants = require("../../../../common/constants");
var _get_private_locations = require("../../../synthetics_service/get_private_locations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const syncParamsSyntheticsParamsRoute = () => ({
  method: 'PUT',
  path: _constants.SYNTHETICS_API_URLS.SYNC_GLOBAL_PARAMS,
  validate: {},
  options: {
    // 5 minutes
    timeout: {
      payload: 1000 * 60 * 5
    }
  },
  writeAccess: true,
  handler: async ({
    syntheticsMonitorClient,
    server,
    spaceId
  }) => {
    const soClient = server.coreStart.savedObjects.createInternalRepository();
    const allPrivateLocations = await (0, _get_private_locations.getPrivateLocations)(soClient);
    if (allPrivateLocations.length > 0) {
      await (0, _sync_global_params_task.asyncGlobalParamsPropagation)({
        server,
        paramsSpacesToSync: [spaceId]
      });
    }
    return {
      success: true
    };
  }
});
exports.syncParamsSyntheticsParamsRoute = syncParamsSyntheticsParamsRoute;