"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.syntheticsInspectTLSRuleRoute = void 0;
var _synthetics_tls = require("@kbn/response-ops-rule-params/synthetics_tls");
var _constants = require("../../../common/constants");
var _tls_rule_executor = require("../../alert_rules/tls_rule/tls_rule_executor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const syntheticsInspectTLSRuleRoute = () => ({
  method: 'POST',
  path: _constants.SYNTHETICS_API_URLS.INSPECT_TLS_RULE,
  validate: {
    body: _synthetics_tls.tlsRuleParamsSchema
  },
  handler: async ({
    request,
    server,
    syntheticsMonitorClient,
    savedObjectsClient,
    context,
    spaceId
  }) => {
    const {
      elasticsearch
    } = await context.core;
    const tlsRule = new _tls_rule_executor.TLSRuleExecutor(new Date(), request.body, savedObjectsClient, elasticsearch.client.asCurrentUser, server, syntheticsMonitorClient, spaceId, 'Inspect TLS Rule');
    return tlsRule.getRuleThresholdOverview();
  }
});
exports.syntheticsInspectTLSRuleRoute = syntheticsInspectTLSRuleRoute;