"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteSyntheticsMonitorRoute = void 0;
var _i18n = require("@kbn/i18n");
var _configSchema = require("@kbn/config-schema");
var _delete_monitor_api = require("./services/delete_monitor_api");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteSyntheticsMonitorRoute = () => ({
  method: 'DELETE',
  path: _constants.SYNTHETICS_API_URLS.SYNTHETICS_MONITORS + '/{id?}',
  validate: {},
  validation: {
    request: {
      body: _configSchema.schema.nullable(_configSchema.schema.object({
        ids: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
          minSize: 1
        })
      })),
      params: _configSchema.schema.object({
        id: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  },
  handler: async routeContext => {
    const {
      request,
      response
    } = routeContext;
    const {
      ids
    } = request.body || {};
    const {
      id: queryId
    } = request.params;
    if (ids && queryId) {
      return response.badRequest({
        body: {
          message: _i18n.i18n.translate('xpack.synthetics.deleteMonitor.errorMultipleIdsProvided', {
            defaultMessage: 'id must be provided either via param or body.'
          })
        }
      });
    }
    const idsToDelete = [...(ids !== null && ids !== void 0 ? ids : []), ...(queryId ? [queryId] : [])];
    if (idsToDelete.length === 0) {
      return response.badRequest({
        body: {
          message: _i18n.i18n.translate('xpack.synthetics.deleteMonitor.errorMultipleIdsProvided', {
            defaultMessage: 'id must be provided either via param or body.'
          })
        }
      });
    }
    const deleteMonitorAPI = new _delete_monitor_api.DeleteMonitorAPI(routeContext);
    const {
      errors
    } = await deleteMonitorAPI.execute({
      monitorIds: idsToDelete
    });
    if (errors && errors.length > 0) {
      return response.ok({
        body: {
          message: _i18n.i18n.translate('xpack.synthetics.deleteMonitor.errorPushingMonitorToService', {
            defaultMessage: 'Error pushing monitor to the service'
          }),
          attributes: {
            errors
          }
        }
      });
    }
    return deleteMonitorAPI.result;
  }
});
exports.deleteSyntheticsMonitorRoute = deleteSyntheticsMonitorRoute;