"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateTempPath = generateTempPath;
exports.generateUniqueId = generateUniqueId;
exports.unzipFile = unzipFile;
var _path = require("path");
var _os = _interopRequireDefault(require("os"));
var _admZip = _interopRequireDefault(require("adm-zip"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function generateUniqueId() {
  return `${Date.now() + Math.floor(Math.random() * 1e13)}`;
}
function generateTempPath() {
  return (0, _path.join)(_os.default.tmpdir(), `synthetics-${generateUniqueId()}`);
}
async function unzipFile(content) {
  const decoded = Buffer.from(content, 'base64');
  const zip = new _admZip.default(decoded);
  const zipEntries = zip.getEntries();
  let allData = '';
  for (const entry of zipEntries) {
    const entryData = entry.getData().toString();
    allData += entryData;
  }
  return allData;
}