"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createPrivateLocationEffect = createPrivateLocationEffect;
exports.deletePrivateLocationEffect = deletePrivateLocationEffect;
exports.editPrivateLocationEffect = editPrivateLocationEffect;
exports.fetchPrivateLocationsEffect = fetchPrivateLocationsEffect;
exports.privateLocationsEffects = void 0;
var _effects = require("redux-saga/effects");
var _i18n = require("@kbn/i18n");
var _fetch_effect = require("../utils/fetch_effect");
var _api = require("./api");
var _actions = require("./actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function* fetchPrivateLocationsEffect() {
  yield (0, _effects.takeLeading)(_actions.getPrivateLocationsAction.get, (0, _fetch_effect.fetchEffectFactory)(_api.getSyntheticsPrivateLocations, _actions.getPrivateLocationsAction.success, _actions.getPrivateLocationsAction.fail));
}
function* createPrivateLocationEffect() {
  yield (0, _effects.takeLeading)(_actions.createPrivateLocationAction.get, (0, _fetch_effect.fetchEffectFactory)(_api.createSyntheticsPrivateLocation, _actions.createPrivateLocationAction.success, _actions.createPrivateLocationAction.fail, _i18n.i18n.translate('xpack.synthetics.createPrivateLocationSuccess', {
    defaultMessage: 'Successfully created private location.'
  }), _i18n.i18n.translate('xpack.synthetics.createPrivateLocationFailure', {
    defaultMessage: 'Failed to create private location.'
  })));
}
function* editPrivateLocationEffect() {
  yield (0, _effects.takeLeading)(_actions.editPrivateLocationAction.get, (0, _fetch_effect.fetchEffectFactory)(_api.editSyntheticsPrivateLocation, _actions.editPrivateLocationAction.success, _actions.editPrivateLocationAction.fail, _i18n.i18n.translate('xpack.synthetics.editPrivateLocationSuccess', {
    defaultMessage: 'Successfully edited private location.'
  }), _i18n.i18n.translate('xpack.synthetics.editPrivateLocationFailure', {
    defaultMessage: 'Failed to edit private location.'
  })));
}
function* deletePrivateLocationEffect() {
  yield (0, _effects.takeLeading)(_actions.deletePrivateLocationAction.get, (0, _fetch_effect.fetchEffectFactory)(_api.deleteSyntheticsPrivateLocation, _actions.deletePrivateLocationAction.success, _actions.deletePrivateLocationAction.fail));
}
const privateLocationsEffects = exports.privateLocationsEffects = [fetchPrivateLocationsEffect, createPrivateLocationEffect, editPrivateLocationEffect, deletePrivateLocationEffect];