"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.executeEsQueryEffect = executeEsQueryEffect;
var _effects = require("redux-saga/effects");
var _i18n = require("@kbn/i18n");
var _kibana_service = require("../../../../utils/kibana_service");
var _http_error = require("../utils/http_error");
var _actions = require("./actions");
var _api = require("./api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function* executeEsQueryEffect() {
  const inProgressRequests = new Set();
  yield (0, _effects.takeEvery)(String(_actions.executeEsQueryAction.get), function* (action) {
    try {
      if (!inProgressRequests.has(action.payload.name)) {
        inProgressRequests.add(action.payload.name);
        const response = yield (0, _effects.call)(_api.executeEsQueryAPI, action.payload);
        inProgressRequests.delete(action.payload.name);
        yield (0, _effects.put)(_actions.executeEsQueryAction.success(response));
      }
    } catch (e) {
      var _serializedError$body, _serializedError$body2;
      inProgressRequests.delete(action.payload.name);
      const serializedError = (0, _http_error.serializeHttpFetchError)(e, action.payload);
      _kibana_service.kibanaService.coreSetup.notifications.toasts.addError({
        ...e,
        message: (_serializedError$body = (_serializedError$body2 = serializedError.body) === null || _serializedError$body2 === void 0 ? void 0 : _serializedError$body2.message) !== null && _serializedError$body !== void 0 ? _serializedError$body : e.message
      }, {
        title: ES_QUERY_FAIL_MESSAGE
      });
      yield (0, _effects.put)(_actions.executeEsQueryAction.fail(serializedError));
    }
  });
}
const ES_QUERY_FAIL_MESSAGE = _i18n.i18n.translate('xpack.synthetics.esQuery.failed', {
  defaultMessage: 'ES query failed.'
});