"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBreadcrumbs = exports.makeBaseBreadcrumb = void 0;
var _i18n = require("@kbn/i18n");
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _url_params = require("../utils/url_params");
var _use_url_params = require("./use_url_params");
var _plugin = require("../../../../common/constants/plugin");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMPTY_QUERY = '?';
const makeBaseBreadcrumb = (uptimePath, params) => {
  if (params) {
    const crumbParams = {
      ...params
    };
    delete crumbParams.statusFilter;
    const query = (0, _url_params.stringifyUrlParams)(crumbParams, true);
    uptimePath += query === EMPTY_QUERY ? '' : query;
  }
  const baseBreadcrumbs = [];
  baseBreadcrumbs.push({
    text: _i18n.i18n.translate('xpack.synthetics.breadcrumbs.overviewBreadcrumbText', {
      defaultMessage: 'Synthetics'
    }),
    href: uptimePath,
    'data-test-subj': 'syntheticsPathBreadcrumb'
  });
  return baseBreadcrumbs;
};
exports.makeBaseBreadcrumb = makeBaseBreadcrumb;
const useBreadcrumbs = extraCrumbs => {
  var _kibana$services$appl, _kibana$services$appl2;
  const params = (0, _use_url_params.useUrlParams)()[0]();
  const kibana = (0, _public.useKibana)();
  const syntheticsPath = (_kibana$services$appl = (_kibana$services$appl2 = kibana.services.application) === null || _kibana$services$appl2 === void 0 ? void 0 : _kibana$services$appl2.getUrlForApp(_plugin.PLUGIN.SYNTHETICS_PLUGIN_ID)) !== null && _kibana$services$appl !== void 0 ? _kibana$services$appl : '';
  const breadcrumbs = (0, _react.useMemo)(() => {
    return makeBaseBreadcrumb(syntheticsPath, params).concat(extraCrumbs);
  }, [extraCrumbs, params, syntheticsPath]);
  (0, _public2.useBreadcrumbs)(breadcrumbs, {
    serverless: kibana.services.serverless
  });
};
exports.useBreadcrumbs = useBreadcrumbs;