"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStepFilters = exports.useNetworkTimingsPrevious24Hours = exports.median = exports.CONTENT_SIZE_LABEL = void 0;
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-shared-plugin/common");
var _moment = _interopRequireDefault(require("moment"));
var _use_journey_steps = require("../../monitor_details/hooks/use_journey_steps");
var _constants = require("../../../../../../common/constants");
var _use_redux_es_search = require("../../../hooks/use_redux_es_search");
var _use_network_timings = require("./use_network_timings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStepFilters = (checkGroupId, stepIndex) => {
  return [{
    term: {
      'monitor.check_group': checkGroupId
    }
  }, {
    term: {
      'synthetics.step.index': stepIndex
    }
  }];
};
exports.useStepFilters = useStepFilters;
const useNetworkTimingsPrevious24Hours = (stepIndexArg, timestampArg, checkGroupIdArg) => {
  const params = (0, _reactRouterDom.useParams)();
  const configId = params.monitorId;
  const checkGroupId = checkGroupIdArg !== null && checkGroupIdArg !== void 0 ? checkGroupIdArg : params.checkGroupId;
  const stepIndex = stepIndexArg !== null && stepIndexArg !== void 0 ? stepIndexArg : Number(params.stepIndex);
  const {
    currentStep
  } = (0, _use_journey_steps.useJourneySteps)();
  const timestamp = timestampArg !== null && timestampArg !== void 0 ? timestampArg : currentStep === null || currentStep === void 0 ? void 0 : currentStep['@timestamp'];
  const runTimeMappings = _common.NETWORK_TIMINGS_FIELDS.reduce((acc, field) => ({
    ...acc,
    [field]: {
      type: 'double'
    }
  }), {});
  const {
    data,
    loading
  } = (0, _use_redux_es_search.useReduxEsSearch)({
    index: _constants.SYNTHETICS_INDEX_PATTERN,
    body: {
      size: 0,
      runtime_mappings: runTimeMappings,
      query: {
        bool: {
          filter: [{
            range: {
              '@timestamp': {
                lte: (0, _moment.default)(timestamp).toISOString(),
                gte: (0, _moment.default)(timestamp).subtract(24, 'hours').toISOString()
              }
            }
          }, {
            term: {
              'synthetics.type': 'journey/network_info'
            }
          }, {
            term: {
              'synthetics.step.index': stepIndex
            }
          }, {
            term: {
              config_id: configId
            }
          }],
          must_not: [{
            term: {
              'monitor.check_group': checkGroupId
            }
          }]
        }
      },
      aggs: {
        testRuns: {
          terms: {
            field: 'monitor.check_group',
            size: 10000
          },
          aggs: {
            dns: {
              sum: {
                field: _common.SYNTHETICS_DNS_TIMINGS
              }
            },
            ssl: {
              sum: {
                field: _common.SYNTHETICS_SSL_TIMINGS
              }
            },
            blocked: {
              sum: {
                field: _common.SYNTHETICS_BLOCKED_TIMINGS
              }
            },
            connect: {
              sum: {
                field: _common.SYNTHETICS_CONNECT_TIMINGS
              }
            },
            receive: {
              sum: {
                field: _common.SYNTHETICS_RECEIVE_TIMINGS
              }
            },
            send: {
              sum: {
                field: _common.SYNTHETICS_SEND_TIMINGS
              }
            },
            wait: {
              sum: {
                field: _common.SYNTHETICS_WAIT_TIMINGS
              }
            },
            total: {
              sum: {
                field: _common.SYNTHETICS_TOTAL_TIMINGS
              }
            }
          }
        }
      }
    }
  }, [], {
    name: `stepNetworkPreviousTimings/${configId}/${checkGroupId}/${stepIndex}`,
    isRequestReady: Boolean(timestamp)
  });
  const aggs = data === null || data === void 0 ? void 0 : data.aggregations;
  const dns = [];
  const connect = [];
  const receive = [];
  const send = [];
  const wait = [];
  const blocked = [];
  const ssl = [];
  aggs === null || aggs === void 0 ? void 0 : aggs.testRuns.buckets.forEach(bucket => {
    var _bucket$dns$value, _bucket$connect$value, _bucket$receive$value, _bucket$send$value, _bucket$wait$value, _bucket$blocked$value, _bucket$ssl$value;
    dns.push((_bucket$dns$value = bucket.dns.value) !== null && _bucket$dns$value !== void 0 ? _bucket$dns$value : 0);
    connect.push((_bucket$connect$value = bucket.connect.value) !== null && _bucket$connect$value !== void 0 ? _bucket$connect$value : 0);
    receive.push((_bucket$receive$value = bucket.receive.value) !== null && _bucket$receive$value !== void 0 ? _bucket$receive$value : 0);
    send.push((_bucket$send$value = bucket.send.value) !== null && _bucket$send$value !== void 0 ? _bucket$send$value : 0);
    wait.push((_bucket$wait$value = bucket.wait.value) !== null && _bucket$wait$value !== void 0 ? _bucket$wait$value : 0);
    blocked.push((_bucket$blocked$value = bucket.blocked.value) !== null && _bucket$blocked$value !== void 0 ? _bucket$blocked$value : 0);
    ssl.push((_bucket$ssl$value = bucket.ssl.value) !== null && _bucket$ssl$value !== void 0 ? _bucket$ssl$value : 0);
  });
  const timings = {
    dns: median(dns),
    connect: median(connect),
    receive: median(receive),
    send: median(send),
    wait: median(wait),
    blocked: median(blocked),
    ssl: median(ssl)
  };
  return {
    loading: loading && !data,
    timings,
    timingsWithLabels: (0, _use_network_timings.getTimingWithLabels)(timings)
  };
};
exports.useNetworkTimingsPrevious24Hours = useNetworkTimingsPrevious24Hours;
const median = arr => {
  if (!arr.length) return 0;
  const s = [...arr].sort((a, b) => a - b);
  const mid = Math.floor(s.length / 2);
  return s.length % 2 === 0 ? (s[mid - 1] + s[mid]) / 2 : s[mid];
};
exports.median = median;
const CONTENT_SIZE_LABEL = exports.CONTENT_SIZE_LABEL = _i18n.i18n.translate('xpack.synthetics.contentSize', {
  defaultMessage: 'Content Size'
});