"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Timings = exports.TIMING_ORDER = exports.MimeTypesMap = exports.MimeType = exports.Metadata = exports.MIME_FILTERS = exports.META_DATA_ORDER_FLYOUT = exports.FriendlyTimingLabels = exports.FriendlyMimetypeLabels = exports.FriendlyFlyoutLabels = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let Timings = exports.Timings = /*#__PURE__*/function (Timings) {
  Timings["Blocked"] = "blocked";
  Timings["Dns"] = "dns";
  Timings["Connect"] = "connect";
  Timings["Ssl"] = "ssl";
  Timings["Send"] = "send";
  Timings["Wait"] = "wait";
  Timings["Receive"] = "receive";
  return Timings;
}({});
let Metadata = exports.Metadata = /*#__PURE__*/function (Metadata) {
  Metadata["Status"] = "status";
  Metadata["ResourceSize"] = "resourceSize";
  Metadata["TransferSize"] = "transferSize";
  Metadata["CertificateIssuer"] = "certificateIssuer";
  Metadata["CertificateIssueDate"] = "certificateIssueDate";
  Metadata["CertificateExpiryDate"] = "certificateExpiryDate";
  Metadata["CertificateSubject"] = "certificateSubject";
  Metadata["IP"] = "ip";
  Metadata["MimeType"] = "mimeType";
  Metadata["RequestStart"] = "requestStart";
  return Metadata;
}({});
const FriendlyTimingLabels = exports.FriendlyTimingLabels = {
  [Timings.Blocked]: _i18n.i18n.translate('xpack.synthetics.synthetics.waterfallChart.labels.timings.blocked', {
    defaultMessage: 'Queued / Blocked'
  }),
  [Timings.Dns]: _i18n.i18n.translate('xpack.synthetics.synthetics.waterfallChart.labels.timings.dns', {
    defaultMessage: 'DNS'
  }),
  [Timings.Connect]: _i18n.i18n.translate('xpack.synthetics.synthetics.waterfallChart.labels.timings.connect', {
    defaultMessage: 'Connecting'
  }),
  [Timings.Ssl]: _i18n.i18n.translate('xpack.synthetics.synthetics.waterfallChart.labels.timings.ssl', {
    defaultMessage: 'TLS'
  }),
  [Timings.Send]: _i18n.i18n.translate('xpack.synthetics.synthetics.waterfallChart.labels.timings.send', {
    defaultMessage: 'Sending request'
  }),
  [Timings.Wait]: _i18n.i18n.translate('xpack.synthetics.synthetics.waterfallChart.labels.timings.wait', {
    defaultMessage: 'Waiting (TTFB)'
  }),
  [Timings.Receive]: _i18n.i18n.translate('xpack.synthetics.synthetics.waterfallChart.labels.timings.receive', {
    defaultMessage: 'Content downloading'
  })
};
const FriendlyFlyoutLabels = exports.FriendlyFlyoutLabels = {
  [Metadata.Status]: _i18n.i18n.translate('xpack.synthetics.synthetics.waterfallChart.labels.metadata.status', {
    defaultMessage: 'Status'
  }),
  [Metadata.MimeType]: _i18n.i18n.translate('xpack.synthetics.synthetics.waterfallChart.labels.metadata.contentType', {
    defaultMessage: 'Content type'
  }),
  [Metadata.RequestStart]: _i18n.i18n.translate('xpack.synthetics.synthetics.waterfallChart.labels.metadata.requestStart', {
    defaultMessage: 'Request start'
  }),
  [Metadata.ResourceSize]: _i18n.i18n.translate('xpack.synthetics.synthetics.waterfallChart.labels.metadata.resourceSize', {
    defaultMessage: 'Resource size'
  }),
  [Metadata.TransferSize]: _i18n.i18n.translate('xpack.synthetics.synthetics.waterfallChart.labels.metadata.transferSize', {
    defaultMessage: 'Transfer size'
  }),
  [Metadata.CertificateIssuer]: _i18n.i18n.translate('xpack.synthetics.synthetics.waterfallChart.labels.metadata.certificateIssuer', {
    defaultMessage: 'Issuer'
  }),
  [Metadata.CertificateIssueDate]: _i18n.i18n.translate('xpack.synthetics.synthetics.waterfallChart.labels.metadata.certificateIssueDate', {
    defaultMessage: 'Valid from'
  }),
  [Metadata.CertificateExpiryDate]: _i18n.i18n.translate('xpack.synthetics.synthetics.waterfallChart.labels.metadata.certificateExpiryDate', {
    defaultMessage: 'Valid until'
  }),
  [Metadata.CertificateSubject]: _i18n.i18n.translate('xpack.synthetics.synthetics.waterfallChart.labels.metadata.certificateSubject', {
    defaultMessage: 'Common name'
  }),
  [Metadata.IP]: _i18n.i18n.translate('xpack.synthetics.synthetics.waterfallChart.labels.metadata.ip', {
    defaultMessage: 'IP'
  })
};
const TIMING_ORDER = exports.TIMING_ORDER = [Timings.Blocked, Timings.Dns, Timings.Connect, Timings.Ssl, Timings.Send, Timings.Wait, Timings.Receive];
const META_DATA_ORDER_FLYOUT = exports.META_DATA_ORDER_FLYOUT = [Metadata.MimeType, Timings.Dns, Timings.Connect, Timings.Ssl, Timings.Wait, Timings.Receive];
let MimeType = exports.MimeType = /*#__PURE__*/function (MimeType) {
  MimeType["Html"] = "html";
  MimeType["Script"] = "script";
  MimeType["Stylesheet"] = "stylesheet";
  MimeType["Media"] = "media";
  MimeType["Image"] = "image";
  MimeType["Font"] = "font";
  MimeType["XHR"] = "xhr";
  MimeType["Other"] = "other";
  return MimeType;
}({});
const FriendlyMimetypeLabels = exports.FriendlyMimetypeLabels = {
  [MimeType.Html]: _i18n.i18n.translate('xpack.synthetics.synthetics.waterfallChart.labels.mimeTypes.html', {
    defaultMessage: 'HTML'
  }),
  [MimeType.Script]: _i18n.i18n.translate('xpack.synthetics.synthetics.waterfallChart.labels.mimeTypes.script', {
    defaultMessage: 'JS'
  }),
  [MimeType.Stylesheet]: _i18n.i18n.translate('xpack.synthetics.synthetics.waterfallChart.labels.mimeTypes.stylesheet', {
    defaultMessage: 'CSS'
  }),
  [MimeType.Image]: _i18n.i18n.translate('xpack.synthetics.synthetics.waterfallChart.labels.mimeTypes.image', {
    defaultMessage: 'Image'
  }),
  [MimeType.Media]: _i18n.i18n.translate('xpack.synthetics.synthetics.waterfallChart.labels.mimeTypes.media', {
    defaultMessage: 'Media'
  }),
  [MimeType.Font]: _i18n.i18n.translate('xpack.synthetics.synthetics.waterfallChart.labels.mimeTypes.font', {
    defaultMessage: 'Font'
  }),
  [MimeType.XHR]: _i18n.i18n.translate('xpack.synthetics.synthetics.waterfallChart.labels.mimeTypes.xhr', {
    defaultMessage: 'XHR'
  }),
  [MimeType.Other]: _i18n.i18n.translate('xpack.synthetics.synthetics.waterfallChart.labels.mimeTypes.other', {
    defaultMessage: 'Other'
  })
};

// NOTE: This list tries to cover the standard spec compliant mime types,
// and a few popular non-standard ones, but it isn't exhaustive.
const MimeTypesMap = exports.MimeTypesMap = {
  'text/html': MimeType.Html,
  'application/javascript': MimeType.Script,
  'application/x-javascript': MimeType.Script,
  'text/javascript': MimeType.Script,
  'text/css': MimeType.Stylesheet,
  // Images
  'image/apng': MimeType.Image,
  'image/bmp': MimeType.Image,
  'image/gif': MimeType.Image,
  'image/x-icon': MimeType.Image,
  'image/jpeg': MimeType.Image,
  'image/png': MimeType.Image,
  'image/svg+xml': MimeType.Image,
  'image/tiff': MimeType.Image,
  'image/webp': MimeType.Image,
  // Common audio / video formats
  'audio/wave': MimeType.Media,
  'audio/wav': MimeType.Media,
  'audio/x-wav': MimeType.Media,
  'audio/x-pn-wav': MimeType.Media,
  'audio/webm': MimeType.Media,
  'video/webm': MimeType.Media,
  'video/mp4': MimeType.Media,
  'audio/ogg': MimeType.Media,
  'video/ogg': MimeType.Media,
  'application/ogg': MimeType.Media,
  // Fonts
  'font/otf': MimeType.Font,
  'font/ttf': MimeType.Font,
  'font/woff': MimeType.Font,
  'font/woff2': MimeType.Font,
  'application/x-font-opentype': MimeType.Font,
  'application/font-woff': MimeType.Font,
  'application/font-woff2': MimeType.Font,
  'application/vnd.ms-fontobject': MimeType.Font,
  'application/font-sfnt': MimeType.Font,
  // XHR
  'application/json': MimeType.XHR
};
const MIME_FILTERS = exports.MIME_FILTERS = [{
  label: FriendlyMimetypeLabels[MimeType.Html],
  mimeType: MimeType.Html
}, {
  label: FriendlyMimetypeLabels[MimeType.Stylesheet],
  mimeType: MimeType.Stylesheet
}, {
  label: FriendlyMimetypeLabels[MimeType.Font],
  mimeType: MimeType.Font
}, {
  label: FriendlyMimetypeLabels[MimeType.Script],
  mimeType: MimeType.Script
}, {
  label: FriendlyMimetypeLabels[MimeType.Image],
  mimeType: MimeType.Image
}, {
  label: FriendlyMimetypeLabels[MimeType.Media],
  mimeType: MimeType.Media
}, {
  label: FriendlyMimetypeLabels[MimeType.XHR],
  mimeType: MimeType.XHR
}, {
  label: FriendlyMimetypeLabels[MimeType.Other],
  mimeType: MimeType.Other
}];