"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewLoader = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _overview_grid_item_loader = require("./overview_grid_item_loader");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OverviewLoader = ({
  rows,
  columns,
  style
}) => {
  const ROWS = rows !== null && rows !== void 0 ? rows : 4;
  const COLUMNS = columns !== null && columns !== void 0 ? columns : 4;
  const loaders = Array(ROWS * COLUMNS).fill(null);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    gutterSize: "m",
    columns: COLUMNS,
    css: style
  }, loaders.map((_, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: i
  }, /*#__PURE__*/_react.default.createElement(_overview_grid_item_loader.OverviewGridItemLoader, null))));
};
exports.OverviewLoader = OverviewLoader;