"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricErrorIcon = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var React = _react;
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _contexts = require("../../../../../contexts");
var _state = require("../../../../../state");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricErrorIcon = ({
  configIdByLocation
}) => {
  const isPopoverOpen = (0, _reactRedux.useSelector)(_state.selectErrorPopoverState);
  const dispatch = (0, _reactRedux.useDispatch)();
  const setIsPopoverOpen = () => {
    dispatch((0, _state.toggleErrorPopoverOpen)(configIdByLocation));
  };
  const timer = (0, _react.useRef)(null);
  const euiShadow = (0, _eui.useEuiShadow)('s');
  const theme = (0, _eui.useEuiTheme)().euiTheme;
  const {
    darkMode
  } = (0, _contexts.useSyntheticsSettingsContext)();
  return /*#__PURE__*/React.createElement("div", {
    css: (0, _react2.css)`
        box-sizing: border-box;
        display: flex;
        flex-direction: column;
        align-items: center;
        gap: 10px;
        width: 32px;
        height: 32px;
        background: ${darkMode ? theme.colors.backgroundBaseSubdued : theme.colors.lightestShade};
        border: 1px solid ${darkMode ? theme.colors.darkShade : theme.colors.lightShade};
        box-shadow: ${euiShadow};
        border-radius: 16px;
        flex: none;
        order: 0;
        flex-grow: 0;
      `,
    onMouseEnter: () => {
      // show popover with delay
      if (timer.current) {
        clearTimeout(timer.current);
      }
      timer.current = setTimeout(() => {
        setIsPopoverOpen();
      }, 300);
    },
    onMouseLeave: () => {
      if (isPopoverOpen) {
        return;
      } else if (timer.current) {
        clearTimeout(timer.current);
      }
    },
    onClick: () => {
      if (configIdByLocation === isPopoverOpen) {
        dispatch((0, _state.toggleErrorPopoverOpen)(null));
      } else {
        dispatch((0, _state.toggleErrorPopoverOpen)(configIdByLocation));
      }
    },
    onKeyDown: e => {
      if (e.key === 'Enter') {
        if (configIdByLocation === isPopoverOpen) {
          dispatch((0, _state.toggleErrorPopoverOpen)(null));
        } else {
          dispatch((0, _state.toggleErrorPopoverOpen)(configIdByLocation));
        }
      }
    }
  }, /*#__PURE__*/React.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "syntheticsMetricItemIconButton",
    iconType: "warning",
    color: "danger",
    size: "m",
    "aria-label": ERROR_DETAILS
  }));
};
exports.MetricErrorIcon = MetricErrorIcon;
const ERROR_DETAILS = _i18n.i18n.translate('xpack.synthetics.errorDetails.label', {
  defaultMessage: 'Error details'
});