"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GridItemsByGroup = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _lodash = require("lodash");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _overview_loader = require("../overview_loader");
var _filter_fields = require("../../../../../utils/filters/filter_fields");
var _use_filters = require("../../../common/monitor_filters/use_filters");
var _grid_group_item = require("./grid_group_item");
var _runtime_types = require("../../../../../../../../common/runtime_types");
var _state = require("../../../../../state");
var _overview_status = require("../../../../../state/overview_status");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GridItemsByGroup = ({
  setFlyoutConfigCallback,
  view
}) => {
  var _selectedGroup$otherV, _selectedGroup$otherV2;
  const [fullScreenGroup, setFullScreenGroup] = (0, _react.useState)('');
  const {
    groupBy: {
      field: groupField,
      order: groupOrder
    }
  } = (0, _reactRedux.useSelector)(_state.selectOverviewState);
  const {
    allConfigs,
    loaded
  } = (0, _reactRedux.useSelector)(_overview_status.selectOverviewStatus);
  const {
    locations: allLocations
  } = (0, _reactRedux.useSelector)(_state.selectServiceLocationsState);
  const data = (0, _use_filters.useFilters)();
  if (!data) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null);
  }
  const {
    monitorTypes,
    locations,
    projects,
    tags
  } = data;
  let selectedGroup = {
    key: 'location',
    items: locations,
    values: (0, _filter_fields.getSyntheticsFilterDisplayValues)(locations, 'locations', allLocations),
    otherValues: {
      label: 'Without any location',
      // All monitors should have a locationId. This array tracks monitors that are missing it, which helps identify potential issues
      items: allConfigs === null || allConfigs === void 0 ? void 0 : allConfigs.filter(monitor => !(0, _lodash.get)(monitor, 'locationId'))
    }
  };
  switch (groupField) {
    case _runtime_types.ConfigKey.MONITOR_TYPE:
      selectedGroup = {
        key: _runtime_types.ConfigKey.MONITOR_TYPE,
        items: monitorTypes,
        values: (0, _filter_fields.getSyntheticsFilterDisplayValues)(monitorTypes, 'monitorTypes', allLocations),
        otherValues: {
          label: _i18n.i18n.translate('xpack.synthetics.monitorsPage.overview.gridItemsByGroup.noType', {
            defaultMessage: 'Invalid monitor type'
          }),
          items: allConfigs === null || allConfigs === void 0 ? void 0 : allConfigs.filter(monitor => !(0, _lodash.get)(monitor, _runtime_types.ConfigKey.MONITOR_TYPE))
        }
      };
      break;
    case 'locationId':
      selectedGroup = {
        key: 'locationLabel',
        items: locations,
        values: (0, _filter_fields.getSyntheticsFilterDisplayValues)(locations, 'locations', allLocations),
        otherValues: {
          label: _i18n.i18n.translate('xpack.synthetics.monitorsPage.overview.gridItemsByGroup.noLocations', {
            defaultMessage: 'Without any location'
          }),
          // All monitors should have a locationId. This array tracks monitors that are missing it, which helps identify potential issues
          items: allConfigs === null || allConfigs === void 0 ? void 0 : allConfigs.filter(monitor => !(0, _lodash.get)(monitor, 'locationId'))
        }
      };
      break;
    case _runtime_types.ConfigKey.TAGS:
      selectedGroup = {
        key: _runtime_types.ConfigKey.TAGS,
        items: tags,
        values: (0, _filter_fields.getSyntheticsFilterDisplayValues)(tags, 'tags', allLocations),
        otherValues: {
          label: _i18n.i18n.translate('xpack.synthetics.monitorsPage.overview.gridItemsByGroup.noTags', {
            defaultMessage: 'Without any tags'
          }),
          items: allConfigs === null || allConfigs === void 0 ? void 0 : allConfigs.filter(monitor => (0, _lodash.get)(monitor, 'tags', []).length === 0)
        }
      };
      break;
    case _runtime_types.ConfigKey.PROJECT_ID:
      selectedGroup = {
        key: 'projectId',
        items: projects,
        values: (0, _filter_fields.getSyntheticsFilterDisplayValues)(projects, 'projects', allLocations),
        otherValues: {
          label: _i18n.i18n.translate('xpack.synthetics.monitorsPage.overview.gridItemsByGroup.uiMonitors', {
            defaultMessage: 'UI Monitors'
          }),
          items: allConfigs === null || allConfigs === void 0 ? void 0 : allConfigs.filter(monitor => !Boolean(monitor.projectId))
        }
      };
      break;
    default:
  }
  const selectedValues = (0, _lodash.orderBy)(selectedGroup.values, 'label', groupOrder !== null && groupOrder !== void 0 ? groupOrder : 'asc');
  if (monitorTypes.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_overview_loader.OverviewLoader, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, selectedValues.map(groupItem => {
    var _allConfigs$filter;
    const filteredMonitors = (_allConfigs$filter = allConfigs === null || allConfigs === void 0 ? void 0 : allConfigs.filter(monitor => {
      const value = (0, _lodash.get)(monitor, selectedGroup.key);
      if (Array.isArray(value)) {
        return value.includes(groupItem.label);
      }
      if (selectedGroup.key === _runtime_types.ConfigKey.MONITOR_TYPE) {
        const typeKey = (0, _lodash.invert)(_filter_fields.monitorTypeKeyLabelMap)[groupItem.label];
        return (0, _lodash.get)(monitor, selectedGroup.key) === typeKey;
      }
      return (0, _lodash.get)(monitor, selectedGroup.key) === groupItem.label;
    })) !== null && _allConfigs$filter !== void 0 ? _allConfigs$filter : [];
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(WrappedPanel, {
      isFullScreen: fullScreenGroup === groupItem.label
    }, /*#__PURE__*/_react.default.createElement(_grid_group_item.GroupGridItem, {
      groupLabel: groupItem.label,
      groupMonitors: filteredMonitors,
      loaded: loaded,
      setFlyoutConfigCallback: setFlyoutConfigCallback,
      setFullScreenGroup: setFullScreenGroup,
      fullScreenGroup: fullScreenGroup,
      view: view
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }));
  }), ((_selectedGroup$otherV = selectedGroup.otherValues.items) !== null && _selectedGroup$otherV !== void 0 ? _selectedGroup$otherV : []).length > 0 && /*#__PURE__*/_react.default.createElement(WrappedPanel, {
    isFullScreen: fullScreenGroup === selectedGroup.otherValues.label
  }, /*#__PURE__*/_react.default.createElement(_grid_group_item.GroupGridItem, {
    groupLabel: selectedGroup.otherValues.label,
    groupMonitors: (_selectedGroup$otherV2 = selectedGroup.otherValues.items) !== null && _selectedGroup$otherV2 !== void 0 ? _selectedGroup$otherV2 : [],
    loaded: loaded,
    setFlyoutConfigCallback: setFlyoutConfigCallback,
    setFullScreenGroup: setFullScreenGroup,
    fullScreenGroup: fullScreenGroup,
    view: view
  })));
};
exports.GridItemsByGroup = GridItemsByGroup;
const WrappedPanel = ({
  isFullScreen,
  children
}) => {
  const ref = (0, _react.useRef)(null);
  if (!isFullScreen) {
    return /*#__PURE__*/_react.default.createElement(StyledPanel, {
      hasShadow: false,
      hasBorder: true
    }, children);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiOverlayMask, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFocusTrap, {
    clickOutsideDisables: true
  }, /*#__PURE__*/_react.default.createElement("div", {
    ref: ref
  }, /*#__PURE__*/_react.default.createElement(FullScreenPanel, {
    hasShadow: false,
    hasBorder: true
  }, children))));
};
const StyledPanel = (0, _styledComponents.default)(_eui.EuiPanel)`
  &&& {
    .fullScreenButton {
      visibility: hidden;
    }
    :hover {
      .fullScreenButton {
        visibility: visible;
      }
    }
  }
`;
const FullScreenPanel = (0, _styledComponents.default)(_eui.EuiPanel)`
  &&& {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    overflow: auto;
  }
`;