"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorRangeFrom = void 0;
var _react = require("react");
var _moment = _interopRequireDefault(require("moment"));
var _monitor_management = require("../../../../../../common/constants/monitor_management");
var _runtime_types = require("../../../../../../common/runtime_types");
var _hooks = require("../../../hooks");
var _use_selected_monitor = require("./use_selected_monitor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMonitorRangeFrom = () => {
  const {
    monitor,
    loading
  } = (0, _use_selected_monitor.useSelectedMonitor)();
  const {
    from,
    to
  } = (0, _hooks.useRefreshedRange)(30, 'days');
  return (0, _react.useMemo)(() => {
    if (monitor !== null && monitor !== void 0 && monitor.created_at) {
      const monitorCreatedDaysAgo = (0, _moment.default)().diff(monitor.created_at, 'days');
      const isProjectMonitor = (monitor === null || monitor === void 0 ? void 0 : monitor[_monitor_management.ConfigKey.MONITOR_SOURCE_TYPE]) === _runtime_types.SourceType.PROJECT;

      // Always look back at lest 3 days to account for reinstated project monitors.
      if ((!isProjectMonitor || monitorCreatedDaysAgo > 3) && monitorCreatedDaysAgo < 30) {
        return {
          to,
          from: monitor.created_at,
          loading
        };
      }
    }
    return {
      to,
      from,
      loading
    };
  }, [monitor, to, from, loading]);
};
exports.useMonitorRangeFrom = useMonitorRangeFrom;