"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScriptRecorderFields = ScriptRecorderFields;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _uploader = require("./uploader");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ScriptRecorderFields({
  onChange,
  script,
  fileName,
  isEditable
}) {
  const [showScript, setShowScript] = (0, _react.useState)(false);
  const handleUpload = (0, _react.useCallback)(({
    scriptText,
    fileName: fileNameT
  }) => {
    onChange({
      scriptText,
      fileName: fileNameT
    });
  }, [onChange]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), isEditable && script ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "aria-label": "Testing script",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, fileName))) : /*#__PURE__*/_react.default.createElement(_uploader.Uploader, {
    onUpload: handleUpload
  }), script && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "syntheticsScriptRecorderFieldsShowScriptButton",
    onClick: () => setShowScript(true),
    iconType: "editorCodeBlock",
    iconSide: "right"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.createPackagePolicy.stepConfigure.monitorIntegrationSettingsSection.browser.recorder.showScriptLabel",
    defaultMessage: "Show script"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isEditable && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "syntheticsScriptRecorderFieldsRemoveScriptButton",
    onClick: () => onChange({
      scriptText: '',
      fileName: ''
    }),
    iconType: "trash",
    iconSide: "right",
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.createPackagePolicy.stepConfigure.monitorIntegrationSettingsSection.browser.recorder.removeScriptLabel",
    defaultMessage: "Remove script"
  }))))), showScript && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: () => setShowScript(false),
    "aria-labelledby": "syntheticsBrowserScriptBlockHeader",
    closeButtonProps: {
      'aria-label': CLOSE_BUTTON_LABEL
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("span", {
    id: "syntheticsBrowserScriptBlockHeader"
  }, fileName || PLACEHOLDER_FILE_NAME))), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "js",
    overflowHeight: '100%',
    fontSize: "m",
    isCopyable: true
  }, script))));
}
const PLACEHOLDER_FILE_NAME = _i18n.i18n.translate('xpack.synthetics.createPackagePolicy.stepConfigure.monitorIntegrationSettingsSection.browser.scriptRecorder.mockFileName', {
  defaultMessage: 'test_script.js'
});
const CLOSE_BUTTON_LABEL = _i18n.i18n.translate('xpack.synthetics.createPackagePolicy.stepConfigure.monitorIntegrationSettingsSection.browser.scriptRecorder.closeButtonLabel', {
  defaultMessage: 'Close script flyout'
});