"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorDetailsPanel = void 0;
exports.frequencyStr = frequencyStr;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _public = require("@kbn/observability-shared-plugin/public");
var _lodash = require("lodash");
var _use_kibana_space = require("../../../../../hooks/use_kibana_space");
var _panel_with_title = require("./panel_with_title");
var _monitor_enabled = require("../../monitors_page/management/monitor_list_table/monitor_enabled");
var _state = require("../../../state");
var _locations_status = require("../../monitor_details/monitor_summary/locations_status");
var _runtime_types = require("../../../../../../common/runtime_types");
var _monitor_type_badge = require("./monitor_type_badge");
var _use_date_format = require("../../../../../hooks/use_date_format");
var _hooks = require("../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorDetailsPanel = ({
  monitor,
  latestPing,
  loading,
  configId,
  hideEnabled = false,
  hideLocations = false,
  hasBorder = true
}) => {
  var _latestPing$url$full, _latestPing$url;
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    space
  } = (0, _use_kibana_space.useKibanaSpace)();
  const {
    spaceId
  } = (0, _hooks.useGetUrlParams)();
  if (!monitor) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 8
    });
  }
  const url = (_latestPing$url$full = latestPing === null || latestPing === void 0 ? void 0 : (_latestPing$url = latestPing.url) === null || _latestPing$url === void 0 ? void 0 : _latestPing$url.full) !== null && _latestPing$url$full !== void 0 ? _latestPing$url$full : monitor[_runtime_types.ConfigKey.URLS];
  const labels = monitor[_runtime_types.ConfigKey.LABELS];
  return /*#__PURE__*/_react.default.createElement(_panel_with_title.PanelWithTitle, {
    paddingSize: "m",
    margin: "none",
    title: MONITOR_DETAILS_LABEL,
    titleLeftAlign: true,
    hasBorder: hasBorder
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column",
    columnWidths: [2, 3],
    compressed: true,
    align: "left"
  }, !hideEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, ENABLED_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, monitor && /*#__PURE__*/_react.default.createElement(_monitor_enabled.MonitorEnabled, {
    initialLoading: loading,
    configId: configId,
    monitor: monitor,
    reloadPage: () => {
      dispatch(_state.getMonitorAction.get({
        monitorId: configId,
        ...(spaceId && spaceId !== (space === null || space === void 0 ? void 0 : space.id) ? {
          spaceId
        } : {})
      }));
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, URL_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    style: {
      wordBreak: 'break-all'
    }
  }, url ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "syntheticsMonitorDetailsPanelLink",
    href: url,
    external: true
  }, url) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, UN_AVAILABLE_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, LAST_RUN_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, latestPing !== null && latestPing !== void 0 && latestPing['@timestamp'] ? /*#__PURE__*/_react.default.createElement(Time, {
    timestamp: latestPing === null || latestPing === void 0 ? void 0 : latestPing['@timestamp']
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, _i18n.i18n.translate('xpack.synthetics.monitorDetailsPanel.TextLabel', {
    defaultMessage: '--'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, LAST_MODIFIED_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(Time, {
    timestamp: monitor.updated_at
  })), monitor[_runtime_types.ConfigKey.PROJECT_ID] && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, PROJECT_ID_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, monitor[_runtime_types.ConfigKey.PROJECT_ID])), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, MONITOR_ID_ITEM_TEXT), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, monitor.id), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, MONITOR_TYPE_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_monitor_type_badge.MonitorTypeBadge, {
    monitorType: monitor.type
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, FREQUENCY_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, frequencyStr(monitor[_runtime_types.ConfigKey.SCHEDULE])), !hideLocations && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, LOCATIONS_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_locations_status.LocationsStatus, {
    configId: configId,
    monitorLocations: monitor.locations
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, TAGS_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_public.TagsList, {
    tags: monitor[_runtime_types.ConfigKey.TAGS]
  })), !(0, _lodash.isEmpty)(labels) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, LABELS_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, Object.entries(labels !== null && labels !== void 0 ? labels : {}).map(([key, value]) => /*#__PURE__*/_react.default.createElement("div", {
    key: key
  }, /*#__PURE__*/_react.default.createElement("strong", null, key), ": ", value)))) : null));
};
exports.MonitorDetailsPanel = MonitorDetailsPanel;
function frequencyStr(frequency) {
  return translateUnitMessage(`${frequency.number} ${unitToString(frequency.unit, parseInt(frequency.number, 10))}`);
}
function unitToString(unit, n) {
  switch (unit) {
    case 's':
      return secondsString(n);
    case 'm':
      return minutesString(n);
    case 'h':
      return hoursString(n);
    case 'd':
      return daysString(n);
    default:
      return unit;
  }
}
const secondsString = n => _i18n.i18n.translate('xpack.synthetics.monitorDetail.seconds', {
  defaultMessage: '{n, plural, one {second} other {seconds}}',
  values: {
    n
  }
});
const minutesString = n => _i18n.i18n.translate('xpack.synthetics.monitorDetail.minutes', {
  defaultMessage: '{n, plural, one {minute} other {minutes}}',
  values: {
    n
  }
});
const hoursString = n => _i18n.i18n.translate('xpack.synthetics.monitorDetail.hours', {
  defaultMessage: '{n, plural, one {hour} other {hours}}',
  values: {
    n
  }
});
const daysString = n => _i18n.i18n.translate('xpack.synthetics.monitorDetail.days', {
  defaultMessage: '{n, plural, one {day} other {days}}',
  values: {
    n
  }
});
function translateUnitMessage(unitMsg) {
  return _i18n.i18n.translate('xpack.synthetics.monitorList.flyout.unitStr', {
    defaultMessage: 'Every {unitMsg}',
    values: {
      unitMsg
    },
    description: 'This displays a message like "Every 10 minutes" or "Every 30 seconds"'
  });
}
const Time = ({
  timestamp
}) => {
  const formatter = (0, _use_date_format.useDateFormat)();
  const dateTimeFormatted = formatter(timestamp);
  return timestamp ? /*#__PURE__*/_react.default.createElement("time", {
    dateTime: timestamp
  }, dateTimeFormatted) : null;
};
const FREQUENCY_LABEL = _i18n.i18n.translate('xpack.synthetics.management.monitorList.frequency', {
  defaultMessage: 'Frequency'
});
const LOCATIONS_LABEL = _i18n.i18n.translate('xpack.synthetics.management.monitorList.locations', {
  defaultMessage: 'Locations'
});
const URL_LABEL = _i18n.i18n.translate('xpack.synthetics.management.monitorList.url', {
  defaultMessage: 'URL'
});
const TAGS_LABEL = _i18n.i18n.translate('xpack.synthetics.management.monitorList.tags', {
  defaultMessage: 'Tags'
});
const LABELS_LABEL = _i18n.i18n.translate('xpack.synthetics.management.monitorList.labels', {
  defaultMessage: 'Labels'
});
const ENABLED_LABEL = _i18n.i18n.translate('xpack.synthetics.detailsPanel.monitorDetails.enabled', {
  defaultMessage: 'Enabled (all locations)'
});
const MONITOR_TYPE_LABEL = _i18n.i18n.translate('xpack.synthetics.detailsPanel.monitorDetails.monitorType', {
  defaultMessage: 'Monitor type'
});
const MONITOR_DETAILS_LABEL = _i18n.i18n.translate('xpack.synthetics.detailsPanel.monitorDetails', {
  defaultMessage: 'Monitor details'
});
const LAST_MODIFIED_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorList.lastModified', {
  defaultMessage: 'Last modified'
});
const LAST_RUN_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorList.lastRunHeaderText', {
  defaultMessage: 'Last run'
});
const PROJECT_ID_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorList.projectIdHeaderText', {
  defaultMessage: 'Project ID'
});
const MONITOR_ID_ITEM_TEXT = _i18n.i18n.translate('xpack.synthetics.monitorList.monitorIdItemText', {
  defaultMessage: 'Monitor ID'
});
const UN_AVAILABLE_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorList.unAvailable', {
  defaultMessage: '(unavailable)'
});