"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusRuleComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _status_rule_viz = require("./status_rule_viz");
var _field_filters = require("./common/field_filters");
var _query_bar = require("./query_bar");
var _status_rule_expression = require("./status_rule_expression");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StatusRuleComponent = ({
  ruleParams,
  setRuleParams
}) => {
  var _ruleParams$kqlQuery;
  const onFiltersChange = (0, _react.useCallback)(val => {
    setRuleParams('kqlQuery', val.kqlQuery);
  }, [setRuleParams]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_query_bar.AlertSearchBar, {
    kqlQuery: (_ruleParams$kqlQuery = ruleParams.kqlQuery) !== null && _ruleParams$kqlQuery !== void 0 ? _ruleParams$kqlQuery : '',
    onChange: onFiltersChange
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_field_filters.FieldFilters, {
    ruleParams: ruleParams,
    setRuleParams: setRuleParams
  }), /*#__PURE__*/_react.default.createElement(_status_rule_viz.StatusRuleViz, {
    ruleParams: ruleParams
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_status_rule_expression.StatusRuleExpression, {
    ruleParams: ruleParams,
    setRuleParams: setRuleParams
  }));
};
exports.StatusRuleComponent = StatusRuleComponent;