"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorFiltersForm = MonitorFiltersForm;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _field_selector = require("./field_selector");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function MonitorFiltersForm() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_field_selector.FieldSelector, {
    label: _i18n.i18n.translate('xpack.synthetics.monitorEdit.syntheticsAvailability.monitor', {
      defaultMessage: 'Monitor name'
    }),
    placeholder: _i18n.i18n.translate('xpack.synthetics.monitorEdit.syntheticsAvailability.monitor.placeholder', {
      defaultMessage: 'Select the Synthetics monitor or choose all'
    }),
    name: "monitorIds",
    dataTestSubj: "syntheticsAvailabilityMonitorSelector"
  }), /*#__PURE__*/_react.default.createElement(_field_selector.FieldSelector, {
    label: _i18n.i18n.translate('xpack.synthetics.monitorEdit.syntheticsAvailability.tags', {
      defaultMessage: 'Tags'
    }),
    placeholder: _i18n.i18n.translate('xpack.synthetics.monitorEdit.syntheticsAvailability.tags.placeholder', {
      defaultMessage: 'Select tags'
    }),
    name: "tags",
    dataTestSubj: "syntheticsAvailabilityTagsSelector"
  }), /*#__PURE__*/_react.default.createElement(_field_selector.FieldSelector, {
    label: _i18n.i18n.translate('xpack.synthetics.monitorEdit.syntheticsAvailability.location', {
      defaultMessage: 'Locations'
    }),
    placeholder: _i18n.i18n.translate('xpack.synthetics.monitorEdit.syntheticsAvailability.location.placeholder', {
      defaultMessage: 'Select the locations'
    }),
    name: "locations",
    dataTestSubj: "syntheticsAvailabilityLocationSelector"
  }), /*#__PURE__*/_react.default.createElement(_field_selector.FieldSelector, {
    label: _i18n.i18n.translate('xpack.synthetics.monitorEdit.syntheticsAvailability.project', {
      defaultMessage: 'Project'
    }),
    placeholder: _i18n.i18n.translate('xpack.synthetics.monitorEdit.syntheticsAvailability.project.placeholder', {
      defaultMessage: 'Select the project'
    }),
    name: "projects",
    dataTestSubj: "syntheticsAvailabilityProjectSelector"
  }), /*#__PURE__*/_react.default.createElement(_field_selector.FieldSelector, {
    label: _i18n.i18n.translate('xpack.synthetics.monitorEdit.syntheticsAvailability.type', {
      defaultMessage: 'Monitor type'
    }),
    placeholder: _i18n.i18n.translate('xpack.synthetics.monitorEdit.syntheticsAvailability.type.placeholder', {
      defaultMessage: 'Select the monitor type'
    }),
    name: "monitorTypes",
    dataTestSubj: "syntheticsAvailabilityProjectSelector"
  })));
}