"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThrottlingConfigValueCodec = exports.ThrottlingConfigCodec = exports.TLSSensitiveFieldsCodec = exports.TLSFieldsCodec = exports.TLSCodec = exports.TCPSimpleFieldsCodec = exports.TCPSensitiveAdvancedFieldsCodec = exports.TCPFieldsCodec = exports.TCPAdvancedFieldsCodec = exports.TCPAdvancedCodec = exports.SyntheticsMonitorWithSecretsCodec = exports.SyntheticsMonitorWithIdCodec = exports.SyntheticsMonitorCodec = exports.MonitorManagementListResultCodec = exports.MonitorFieldsResultCodec = exports.MonitorFieldsCodec = exports.MonitorDefaultsCodec = exports.ICMPSimpleFieldsCodec = exports.ICMPFieldsCodec = exports.ICMPAdvancedFieldsCodec = exports.HeartbeatConfigCodec = exports.HTTPSimpleFieldsCodec = exports.HTTPSensitiveAdvancedFieldsCodec = exports.HTTPFieldsCodec = exports.HTTPAdvancedFieldsCodec = exports.HTTPAdvancedCodec = exports.EncryptedTCPFieldsCodec = exports.EncryptedSyntheticsSavedMonitorCodec = exports.EncryptedSyntheticsMonitorCodec = exports.EncryptedHTTPFieldsCodec = exports.EncryptedBrowserSimpleFieldsCodec = exports.EncryptedBrowserFieldsCodec = exports.EncryptedBrowserAdvancedFieldsCodec = exports.CommonFieldsCodec = exports.BrowserSimpleFieldsCodec = exports.BrowserSensitiveSimpleFieldsCodec = exports.BrowserSensitiveAdvancedFieldsCodec = exports.BrowserFieldsCodec = exports.BrowserAdvancedFieldsCodec = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
var _alert_config = require("./alert_config");
var _config_key = require("./config_key");
var _locations = require("./locations");
var _monitor_configs = require("./monitor_configs");
var _monitor_meta_data = require("./monitor_meta_data");
var _synthetics_private_locations = require("./synthetics_private_locations");
var _common = require("../common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ScheduleCodec = t.interface({
  number: t.string,
  unit: _monitor_configs.ScheduleUnitCodec
});

// TLSFields
const TLSFieldsCodec = exports.TLSFieldsCodec = t.partial({
  [_config_key.ConfigKey.TLS_CERTIFICATE_AUTHORITIES]: t.union([t.string, t.array(t.string)]),
  [_config_key.ConfigKey.TLS_CERTIFICATE]: t.string,
  [_config_key.ConfigKey.TLS_VERIFICATION_MODE]: _monitor_configs.VerificationModeCodec,
  [_config_key.ConfigKey.TLS_VERSION]: t.array(_monitor_configs.TLSVersionCodec)
});
const TLSSensitiveFieldsCodec = exports.TLSSensitiveFieldsCodec = t.partial({
  [_config_key.ConfigKey.TLS_KEY]: t.string,
  [_config_key.ConfigKey.TLS_KEY_PASSPHRASE]: t.string
});
const TLSCodec = exports.TLSCodec = t.intersection([TLSFieldsCodec, TLSSensitiveFieldsCodec]);
const MonitorLocationsCodec = (0, _securitysolutionIoTsTypes.NonEmptyArray)(t.union([_locations.MonitorServiceLocationCodec, _synthetics_private_locations.PrivateLocationCodec]));
// CommonFields
const CommonFieldsCodec = exports.CommonFieldsCodec = t.intersection([t.interface({
  [_config_key.ConfigKey.NAME]: _securitysolutionIoTsTypes.NonEmptyString,
  [_config_key.ConfigKey.NAMESPACE]: _common.NameSpaceString,
  [_config_key.ConfigKey.MONITOR_TYPE]: _monitor_configs.MonitorTypeCodec,
  [_config_key.ConfigKey.ENABLED]: t.boolean,
  [_config_key.ConfigKey.SCHEDULE]: ScheduleCodec,
  [_config_key.ConfigKey.APM_SERVICE_NAME]: t.string,
  [_config_key.ConfigKey.TAGS]: t.array(t.string),
  [_config_key.ConfigKey.LOCATIONS]: MonitorLocationsCodec,
  [_config_key.ConfigKey.MONITOR_QUERY_ID]: t.string,
  [_config_key.ConfigKey.CONFIG_ID]: t.string,
  [_config_key.ConfigKey.MAX_ATTEMPTS]: t.number
}), t.partial({
  [_config_key.ConfigKey.FORM_MONITOR_TYPE]: _monitor_configs.FormMonitorTypeCodec,
  [_config_key.ConfigKey.TIMEOUT]: t.union([_common.TimeoutString, t.null, t.number]),
  [_config_key.ConfigKey.REVISION]: t.number,
  [_config_key.ConfigKey.MONITOR_SOURCE_TYPE]: _monitor_configs.SourceTypeCodec,
  [_config_key.ConfigKey.CONFIG_HASH]: t.string,
  [_config_key.ConfigKey.JOURNEY_ID]: t.string,
  [_config_key.ConfigKey.PROJECT_ID]: t.string,
  [_config_key.ConfigKey.ORIGINAL_SPACE]: t.string,
  [_config_key.ConfigKey.CUSTOM_HEARTBEAT_ID]: t.string,
  [_config_key.ConfigKey.ALERT_CONFIG]: _alert_config.AlertConfigsCodec,
  [_config_key.ConfigKey.PARAMS]: t.string,
  [_config_key.ConfigKey.LABELS]: t.record(t.string, t.string),
  [_config_key.ConfigKey.MAINTENANCE_WINDOWS]: t.array(t.string),
  [_config_key.ConfigKey.KIBANA_SPACES]: t.array(t.string),
  retest_on_failure: t.boolean
})]);

// TCP Simple Fields
const TCPSimpleFieldsCodec = exports.TCPSimpleFieldsCodec = t.intersection([t.interface({
  [_config_key.ConfigKey.METADATA]: _monitor_meta_data.MetadataCodec,
  [_config_key.ConfigKey.HOSTS]: (0, _common.getNonEmptyStringCodec)('host'),
  [_config_key.ConfigKey.PORT]: t.union([t.number, t.null])
}), t.partial({
  [_config_key.ConfigKey.URLS]: t.string
}), CommonFieldsCodec]);

// TCPAdvancedFields
const TCPAdvancedFieldsCodec = exports.TCPAdvancedFieldsCodec = t.intersection([t.interface({
  [_config_key.ConfigKey.PROXY_URL]: t.string,
  [_config_key.ConfigKey.PROXY_USE_LOCAL_RESOLVER]: t.boolean
}), t.partial({
  [_config_key.ConfigKey.MODE]: _monitor_configs.ModeCodec,
  [_config_key.ConfigKey.IPV4]: t.boolean,
  [_config_key.ConfigKey.IPV6]: t.boolean
})]);
const TCPSensitiveAdvancedFieldsCodec = exports.TCPSensitiveAdvancedFieldsCodec = t.interface({
  [_config_key.ConfigKey.RESPONSE_RECEIVE_CHECK]: t.string,
  [_config_key.ConfigKey.REQUEST_SEND_CHECK]: t.string
});
const TCPAdvancedCodec = exports.TCPAdvancedCodec = t.intersection([TCPAdvancedFieldsCodec, TCPSensitiveAdvancedFieldsCodec]);
// TCPFields
// All fields for TCP monitor, excluding sensitive fields
const EncryptedTCPFieldsCodec = exports.EncryptedTCPFieldsCodec = t.intersection([TCPSimpleFieldsCodec, TCPAdvancedFieldsCodec, TLSFieldsCodec]);

// All fields for TCP monitor, including sensitive fields
const TCPFieldsCodec = exports.TCPFieldsCodec = t.intersection([EncryptedTCPFieldsCodec, TCPSensitiveAdvancedFieldsCodec, TLSSensitiveFieldsCodec]);
// ICMP SimpleFields
const ICMPSimpleFieldsCodec = exports.ICMPSimpleFieldsCodec = t.intersection([t.interface({
  [_config_key.ConfigKey.HOSTS]: _securitysolutionIoTsTypes.NonEmptyString,
  [_config_key.ConfigKey.WAIT]: t.string
}), CommonFieldsCodec]);
// ICMPAdvancedFields
const ICMPAdvancedFieldsCodec = exports.ICMPAdvancedFieldsCodec = t.partial({
  [_config_key.ConfigKey.MODE]: _monitor_configs.ModeCodec,
  [_config_key.ConfigKey.IPV4]: t.boolean,
  [_config_key.ConfigKey.IPV6]: t.boolean
});

// ICMPFields
const ICMPFieldsCodec = exports.ICMPFieldsCodec = t.intersection([ICMPSimpleFieldsCodec, ICMPAdvancedFieldsCodec]);
// HTTPSimpleFields
const HTTPSimpleFieldsCodec = exports.HTTPSimpleFieldsCodec = t.intersection([t.interface({
  [_config_key.ConfigKey.METADATA]: _monitor_meta_data.MetadataCodec,
  // string is for yaml config and number for public api
  [_config_key.ConfigKey.MAX_REDIRECTS]: t.union([t.string, t.number]),
  [_config_key.ConfigKey.URLS]: (0, _common.getNonEmptyStringCodec)('url'),
  [_config_key.ConfigKey.PORT]: t.union([t.number, t.null])
}), CommonFieldsCodec]);
// HTTPAdvancedFields
const HTTPAdvancedFieldsCodec = exports.HTTPAdvancedFieldsCodec = t.intersection([t.interface({
  [_config_key.ConfigKey.PROXY_URL]: t.string,
  [_config_key.ConfigKey.RESPONSE_BODY_INDEX]: _monitor_configs.ResponseBodyIndexPolicyCodec,
  [_config_key.ConfigKey.RESPONSE_HEADERS_INDEX]: t.boolean,
  [_config_key.ConfigKey.RESPONSE_STATUS_CHECK]: t.array(t.string),
  [_config_key.ConfigKey.REQUEST_METHOD_CHECK]: t.string
}), t.partial({
  [_config_key.ConfigKey.MODE]: _monitor_configs.ModeCodec,
  [_config_key.ConfigKey.RESPONSE_BODY_MAX_BYTES]: t.string,
  [_config_key.ConfigKey.IPV4]: t.boolean,
  [_config_key.ConfigKey.IPV6]: t.boolean
})]);
const HTTPSensitiveAdvancedFieldsCodec = exports.HTTPSensitiveAdvancedFieldsCodec = t.intersection([t.interface({
  [_config_key.ConfigKey.PASSWORD]: t.string,
  [_config_key.ConfigKey.RESPONSE_BODY_CHECK_NEGATIVE]: t.array(t.string),
  [_config_key.ConfigKey.RESPONSE_BODY_CHECK_POSITIVE]: t.array(t.string),
  [_config_key.ConfigKey.RESPONSE_HEADERS_CHECK]: t.record(t.string, t.string),
  [_config_key.ConfigKey.REQUEST_BODY_CHECK]: _monitor_configs.RequestBodyCheckCodec,
  [_config_key.ConfigKey.REQUEST_HEADERS_CHECK]: t.record(t.string, t.string),
  [_config_key.ConfigKey.USERNAME]: t.string
}), t.partial({
  [_config_key.ConfigKey.PROXY_HEADERS]: t.record(t.string, t.string),
  [_config_key.ConfigKey.RESPONSE_JSON_CHECK]: t.array(_monitor_configs.ResponseCheckJSONCodec)
})]);
const HTTPAdvancedCodec = exports.HTTPAdvancedCodec = t.intersection([HTTPAdvancedFieldsCodec, HTTPSensitiveAdvancedFieldsCodec]);

// HTTPFields
// All fields for HTTP monitor, excluding sensitive fields
const EncryptedHTTPFieldsCodec = exports.EncryptedHTTPFieldsCodec = t.intersection([HTTPSimpleFieldsCodec, HTTPAdvancedFieldsCodec, TLSFieldsCodec]);

// All fields for HTTP monitor, including sensitive fields
const HTTPFieldsCodec = exports.HTTPFieldsCodec = t.intersection([EncryptedHTTPFieldsCodec, HTTPSensitiveAdvancedFieldsCodec, TLSSensitiveFieldsCodec]);
const EncryptedBrowserSimpleFieldsCodec = exports.EncryptedBrowserSimpleFieldsCodec = t.intersection([t.intersection([t.interface({
  [_config_key.ConfigKey.METADATA]: _monitor_meta_data.MetadataCodec
}), t.partial({
  [_config_key.ConfigKey.PLAYWRIGHT_OPTIONS]: t.string,
  [_config_key.ConfigKey.TEXT_ASSERTION]: t.string
})]), CommonFieldsCodec]);
const BrowserSensitiveSimpleFieldsCodec = exports.BrowserSensitiveSimpleFieldsCodec = t.intersection([t.interface({
  [_config_key.ConfigKey.SOURCE_INLINE]: _common.InlineScriptString,
  [_config_key.ConfigKey.SOURCE_PROJECT_CONTENT]: t.string,
  [_config_key.ConfigKey.URLS]: t.union([t.string, t.null]),
  [_config_key.ConfigKey.PORT]: t.union([t.number, t.null])
}), CommonFieldsCodec]);
const ThrottlingConfigValueCodec = exports.ThrottlingConfigValueCodec = t.interface({
  download: t.string,
  upload: t.string,
  latency: t.string
});
const ThrottlingConfigCodec = exports.ThrottlingConfigCodec = t.interface({
  value: t.union([ThrottlingConfigValueCodec, t.null]),
  label: t.string,
  id: t.string
});
const EncryptedBrowserAdvancedFieldsCodec = exports.EncryptedBrowserAdvancedFieldsCodec = t.interface({
  [_config_key.ConfigKey.SCREENSHOTS]: t.string,
  [_config_key.ConfigKey.JOURNEY_FILTERS_MATCH]: t.string,
  [_config_key.ConfigKey.JOURNEY_FILTERS_TAGS]: t.array(t.string),
  [_config_key.ConfigKey.IGNORE_HTTPS_ERRORS]: t.boolean,
  [_config_key.ConfigKey.THROTTLING_CONFIG]: ThrottlingConfigCodec
});
const BrowserSimpleFieldsCodec = exports.BrowserSimpleFieldsCodec = t.intersection([EncryptedBrowserSimpleFieldsCodec, BrowserSensitiveSimpleFieldsCodec]);
const BrowserSensitiveAdvancedFieldsCodec = exports.BrowserSensitiveAdvancedFieldsCodec = t.interface({
  [_config_key.ConfigKey.SYNTHETICS_ARGS]: t.array(t.string)
});
const BrowserAdvancedFieldsCodec = exports.BrowserAdvancedFieldsCodec = t.intersection([EncryptedBrowserAdvancedFieldsCodec, BrowserSensitiveAdvancedFieldsCodec]);

// All fields for Browser monitor, excluding sensitive fields
const EncryptedBrowserFieldsCodec = exports.EncryptedBrowserFieldsCodec = t.intersection([EncryptedBrowserSimpleFieldsCodec, EncryptedBrowserAdvancedFieldsCodec, TLSFieldsCodec]);

// All fields for Browser monitor, including sensitive fields
const BrowserFieldsCodec = exports.BrowserFieldsCodec = t.intersection([BrowserSimpleFieldsCodec, BrowserAdvancedFieldsCodec, TLSCodec]);

// MonitorFields, represents any possible monitor type
const MonitorFieldsCodec = exports.MonitorFieldsCodec = t.intersection([HTTPFieldsCodec, TCPFieldsCodec, ICMPSimpleFieldsCodec, BrowserFieldsCodec]);
const MonitorFieldsResultCodec = exports.MonitorFieldsResultCodec = t.intersection([MonitorFieldsCodec, t.interface({
  id: t.string,
  updated_at: t.string,
  created_at: t.string
})]);

// Monitor, represents one of (Icmp | Tcp | Http | Browser) decrypted
const SyntheticsMonitorCodec = exports.SyntheticsMonitorCodec = t.union([HTTPFieldsCodec, TCPFieldsCodec, ICMPSimpleFieldsCodec, BrowserFieldsCodec]);

// Monitor, represents one of (Icmp | Tcp | Http | Browser) encrypted
const EncryptedSyntheticsMonitorCodec = exports.EncryptedSyntheticsMonitorCodec = t.union([EncryptedHTTPFieldsCodec, EncryptedTCPFieldsCodec, ICMPSimpleFieldsCodec, EncryptedBrowserFieldsCodec]);
const SyntheticsMonitorWithIdCodec = exports.SyntheticsMonitorWithIdCodec = t.intersection([SyntheticsMonitorCodec, t.interface({
  id: t.string,
  updated_at: t.string,
  created_at: t.string
})]);
const HeartbeatFieldsCodec = t.intersection([t.interface({
  config_id: t.string
}), t.partial({
  run_once: t.boolean,
  test_run_id: t.string,
  'monitor.project.name': t.string,
  'monitor.id': t.string,
  'monitor.project.id': t.string,
  'monitor.fleet_managed': t.boolean,
  meta: t.record(t.string, t.union([t.string, t.array(t.string)]))
})]);
const HeartbeatConfigCodec = exports.HeartbeatConfigCodec = t.intersection([SyntheticsMonitorCodec, t.interface({
  id: t.string
}), t.partial({
  fields_under_root: t.boolean,
  fields: HeartbeatFieldsCodec
})]);
const EncryptedSyntheticsSavedMonitorCodec = exports.EncryptedSyntheticsSavedMonitorCodec = t.intersection([EncryptedSyntheticsMonitorCodec, t.interface({
  id: t.string,
  updated_at: t.string,
  created_at: t.string
})]);
const MonitorDefaultsCodec = exports.MonitorDefaultsCodec = t.interface({
  [_monitor_configs.MonitorTypeEnum.HTTP]: HTTPFieldsCodec,
  [_monitor_configs.MonitorTypeEnum.TCP]: TCPFieldsCodec,
  [_monitor_configs.MonitorTypeEnum.ICMP]: ICMPSimpleFieldsCodec,
  [_monitor_configs.MonitorTypeEnum.BROWSER]: BrowserFieldsCodec
});
const MonitorManagementListResultCodec = exports.MonitorManagementListResultCodec = t.type({
  monitors: t.array(EncryptedSyntheticsSavedMonitorCodec),
  page: t.number,
  perPage: t.number,
  total: t.union([t.number, t.null]),
  absoluteTotal: t.union([t.number, t.null]),
  syncErrors: t.union([_locations.ServiceLocationErrors, t.null])
});
const SyntheticsMonitorWithSecretsCodec = exports.SyntheticsMonitorWithSecretsCodec = t.intersection([EncryptedSyntheticsMonitorCodec, t.interface({
  secrets: t.string
})]);