"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateClassicIngestPipelineBody = generateClassicIngestPipelineBody;
exports.generateIngestPipeline = generateIngestPipeline;
var _streamsSchema = require("@kbn/streams-schema");
var _constants = require("../../../../common/constants");
var _logs_default_pipeline = require("./logs_default_pipeline");
var _name = require("./name");
var _processing = require("../helpers/processing");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function generateIngestPipeline(name, definition, {
  isServerless
}) {
  const isWiredStream = _streamsSchema.Streams.WiredStream.Definition.is(definition);
  return {
    id: (0, _name.getProcessingPipelineName)(name),
    processors: [...((0, _streamsSchema.isRoot)(definition.name) ? (0, _logs_default_pipeline.getLogsDefaultPipelineProcessors)(isServerless) : []), ...(!(0, _streamsSchema.isRoot)(definition.name) && isWiredStream ? [{
      script: {
        source: `
                  if (ctx["stream.name"] != params.parentName) {
                    throw new IllegalArgumentException('stream.name is not set properly - did you send the document directly to a child stream instead of the main logs stream?');
                  }
                `,
        lang: 'painless',
        params: {
          parentName: (0, _streamsSchema.getParentId)(definition.name)
        }
      }
    }] : []), {
      script: {
        source: 'ctx["stream.name"] = params.field',
        lang: 'painless',
        params: {
          field: definition.name
        }
      }
    }, ...(isWiredStream && (0, _processing.formatToIngestProcessors)(definition.ingest.processing) || []), {
      pipeline: {
        name: `${name}@stream.reroutes`,
        ignore_missing_pipeline: true
      }
    }],
    _meta: {
      description: `Default pipeline for the ${name} stream`,
      managed: true
    },
    version: _constants.ASSET_VERSION
  };
}
function generateClassicIngestPipelineBody(definition) {
  return {
    processors: (0, _processing.formatToIngestProcessors)(definition.ingest.processing),
    _meta: {
      description: `Stream-managed pipeline for the ${definition.name} stream`,
      managed: true
    },
    version: _constants.ASSET_VERSION
  };
}