"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContentPackObjectsList = ContentPackObjectsList;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ContentPackObjectsList({
  objects,
  onSelectionChange
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: objects.filter(({
      type
    }) => type === 'dashboard'),
    itemId: entry => entry.id,
    columns: [{
      name: 'Asset name',
      render: entry => {
        if (entry.type === 'dashboard') {
          return entry.attributes.title;
        }
        return 'unknown object type';
      },
      truncateText: true
    }, {
      name: 'Type',
      render: entry => {
        const iconType = 'dashboardApp';
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "hollow",
          iconType: iconType,
          iconSide: "left"
        }, (0, _lodash.capitalize)(entry.type));
      }
    }],
    rowHeader: "objectName",
    selection: {
      onSelectionChange: selectedObjects => {
        onSelectionChange(selectedObjects);
      }
    }
  });
}