"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegesWarningIconWrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const insufficientPrivilegesText = _i18n.i18n.translate('xpack.streams.insufficientPrivilegesMessage', {
  defaultMessage: "You don't have sufficient privileges to access this information."
});
const PrivilegesWarningIconWrapper = ({
  hasPrivileges,
  title,
  mode = 'popover',
  iconColor = 'warning',
  popoverCss,
  children
}) => {
  const [isPopoverOpen, togglePopover] = (0, _useToggle.default)(false);
  const handleButtonClick = togglePopover;
  if (hasPrivileges) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  }
  return mode === 'popover' ? /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    css: popoverCss,
    attachToAnchor: true,
    anchorPosition: "downCenter",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": `streamsInsufficientPrivileges-${title}`,
      "aria-label": insufficientPrivilegesText,
      title: insufficientPrivilegesText,
      iconType: "warning",
      color: iconColor,
      onClick: handleButtonClick
    }),
    isOpen: isPopoverOpen,
    closePopover: togglePopover
  }, insufficientPrivilegesText) : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: insufficientPrivilegesText
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    "data-test-subj": `streamsInsufficientPrivileges-${title}`,
    "aria-label": insufficientPrivilegesText,
    title: insufficientPrivilegesText,
    type: "warning",
    color: iconColor
  }), children));
};
exports.PrivilegesWarningIconWrapper = PrivilegesWarningIconWrapper;