"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreviewPanel = PreviewPanel;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _use_async_sample = require("../../../hooks/queries/use_async_sample");
var _use_timefilter = require("../../../hooks/use_timefilter");
var _use_debounce = require("../../../util/use_debounce");
var _asset_image = require("../../asset_image");
var _streams_app_search_bar = require("../../streams_app_search_bar");
var _preview_table = require("../preview_table");
var _preview_matches = require("./preview_matches");
var _stream_routing_state_machine = require("./state_management/stream_routing_state_machine");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function PreviewPanel() {
  const routingSnapshot = (0, _stream_routing_state_machine.useStreamsRoutingSelector)(snapshot => snapshot);
  const isIdle = routingSnapshot.matches({
    ready: 'idle'
  });
  const isCreatingNewRule = routingSnapshot.matches({
    ready: 'creatingNewRule'
  });
  const isEditingRule = routingSnapshot.matches({
    ready: 'editingRule'
  });
  const isReorideringRules = routingSnapshot.matches({
    ready: 'reorderingRules'
  });
  const condition = isCreatingNewRule ? (0, _stream_routing_state_machine.selectCurrentRule)(routingSnapshot.context).if : undefined;
  const definition = routingSnapshot.context.definition;
  const debouncedCondition = (0, _use_debounce.useDebounced)(condition, 300);
  const {
    timeState,
    timeState$
  } = (0, _use_timefilter.useTimefilter)();
  const {
    isLoadingDocuments,
    documents,
    documentsError,
    refresh,
    approximateMatchingPercentage,
    isLoadingDocumentCounts,
    documentCountsError
  } = (0, _use_async_sample.useAsyncSample)({
    condition: debouncedCondition,
    start: timeState.start,
    end: timeState.end,
    size: 100,
    streamDefinition: definition
  });
  const hasDocuments = !(0, _lodash.isEmpty)(documents);
  (0, _react.useEffect)(() => {
    const subscription = timeState$.subscribe({
      next: ({
        kind
      }) => {
        if (kind === 'override') {
          refresh();
        }
      }
    });
    return () => {
      subscription.unsubscribe();
    };
  }, [timeState$, refresh]);
  let content;
  if (isIdle) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      icon: /*#__PURE__*/_react.default.createElement(_asset_image.AssetImage, {
        type: "yourPreviewWillAppearHere"
      }),
      titleSize: "s",
      title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.streams.streamDetail.preview.editPreviewMessageEmpty', {
        defaultMessage: 'Your preview will appear here'
      })),
      body: _i18n.i18n.translate('xpack.streams.streamDetail.preview.editPreviewMessageEmptyDescription', {
        defaultMessage: 'Create a new child stream to see what will be routed to it based on the conditions'
      })
    });
  } else if (isEditingRule || isReorideringRules) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      icon: /*#__PURE__*/_react.default.createElement(_asset_image.AssetImage, null),
      titleSize: "s",
      title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.streams.streamDetail.preview.editPreviewMessage', {
        defaultMessage: 'Preview is not available while editing or reordering streams'
      })),
      body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.streams.streamDetail.preview.editPreviewMessageBody', {
        defaultMessage: 'You will find here the result from the conditions you have made once you save the changes'
      })), /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.streams.streamDetail.preview.editPreviewReorderingWarning', {
        defaultMessage: 'Additionally, you will not be able to edit existing streams while reordering them, you should save or cancel your changes first.'
      })))
    });
  } else if (isCreatingNewRule && isLoadingDocuments && !hasDocuments) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
        logo: "logoLogging",
        size: "xl"
      }),
      titleSize: "s",
      title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.streams.streamDetail.preview.loadingPreviewTitle', {
        defaultMessage: 'Loading routing preview'
      })),
      body: _i18n.i18n.translate('xpack.streams.streamDetail.preview.loadingPreviewBody', {
        defaultMessage: 'This may take a few moments depending on the complexity of the conditions and the amount of data'
      })
    });
  } else if (isCreatingNewRule && documentsError) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      icon: /*#__PURE__*/_react.default.createElement(_asset_image.AssetImage, {
        type: "noResults"
      }),
      color: "danger",
      titleSize: "s",
      title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.streams.streamDetail.preview.error', {
        defaultMessage: 'Error loading preview'
      })),
      body: documentsError.message
    });
  } else if (isCreatingNewRule && !hasDocuments) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      icon: /*#__PURE__*/_react.default.createElement(_asset_image.AssetImage, {
        type: "noResults"
      }),
      titleSize: "s",
      title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.streams.streamDetail.preview.empty', {
        defaultMessage: 'No documents to preview'
      }))
    });
  } else if (isCreatingNewRule && hasDocuments) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_preview_matches.PreviewMatches, {
      approximateMatchingPercentage: approximateMatchingPercentage,
      error: documentCountsError,
      isLoading: isLoadingDocumentCounts
    })), /*#__PURE__*/_react.default.createElement(_preview_table.PreviewTable, {
      documents: documents !== null && documents !== void 0 ? documents : []
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isLoadingDocuments && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    component: "span",
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "inspect"
  }), /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.streams.streamDetail.preview.header', {
    defaultMessage: 'Data Preview'
  }))), /*#__PURE__*/_react.default.createElement(_streams_app_search_bar.StreamsAppSearchBar, {
    showDatePicker: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, content));
}