"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewRoutingStreamEntry = NewRoutingStreamEntry;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _condition_editor = require("../condition_editor");
var _control_bars = require("./control_bars");
var _stream_routing_state_machine = require("./state_management/stream_routing_state_machine");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function NewRoutingStreamEntry() {
  const panelRef = (0, _react.useRef)(null);
  const {
    changeRule
  } = (0, _stream_routing_state_machine.useStreamRoutingEvents)();
  const currentRule = (0, _stream_routing_state_machine.useStreamsRoutingSelector)(snapshot => (0, _stream_routing_state_machine.selectCurrentRule)(snapshot.context));
  (0, _react.useEffect)(() => {
    if (panelRef.current) {
      panelRef.current.scrollIntoView({
        behavior: 'smooth',
        block: 'center'
      });
    }
  }, []);
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: panelRef
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.streams.streamDetailRouting.name', {
      defaultMessage: 'Stream name'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "streamsAppRoutingStreamEntryNameField",
    value: currentRule.destination,
    fullWidth: true,
    autoFocus: true,
    compressed: true,
    onChange: e => changeRule({
      destination: e.target.value
    })
  })), /*#__PURE__*/_react.default.createElement(_condition_editor.RoutingConditionEditor, {
    condition: currentRule.if,
    onConditionChange: condition => changeRule({
      if: condition
    })
  }), /*#__PURE__*/_react.default.createElement(_control_bars.AddRoutingRuleControls, null))));
}