"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RetentionSummary = RetentionSummary;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _insufficient_privileges = require("../../insufficient_privileges/insufficient_privileges");
var _format_bytes = require("./helpers/format_bytes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const statCss = (0, _react2.css)`
  min-width: 200px;
`;
function RetentionSummary({
  definition,
  stats,
  isLoadingStats,
  statsError
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    css: statCss,
    isLoading: isLoadingStats || !stats,
    titleSize: "m",
    title: /*#__PURE__*/_react.default.createElement(_insufficient_privileges.PrivilegesWarningIconWrapper, {
      hasPrivileges: definition.privileges.monitor,
      title: "storageSize"
    }, statsError || !stats || !stats.sizeBytes ? '-' : (0, _format_bytes.formatBytes)(stats.sizeBytes)),
    description: _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.storageSize', {
      defaultMessage: 'Storage size'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    css: statCss,
    isLoading: isLoadingStats || !stats,
    titleSize: "m",
    title: /*#__PURE__*/_react.default.createElement(_insufficient_privileges.PrivilegesWarningIconWrapper, {
      hasPrivileges: definition.privileges.monitor,
      title: "totalDocCount"
    }, statsError || !stats || !stats.totalDocs ? '-' : (0, _eui.formatNumber)(stats.totalDocs, '0,0')),
    description: _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.totalDocs', {
      defaultMessage: 'Total doc count'
    })
  }));
}