"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.previewDocsFilterOptions = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const previewDocsFilterOptions = exports.previewDocsFilterOptions = {
  outcome_filter_all: {
    id: 'outcome_filter_all',
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.outcomeControls.all', {
      defaultMessage: 'All samples'
    })
  },
  outcome_filter_parsed: {
    id: 'outcome_filter_parsed',
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.outcomeControls.parsed', {
      defaultMessage: 'Parsed'
    })
  },
  outcome_filter_partially_parsed: {
    id: 'outcome_filter_partially_parsed',
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.outcomeControls.partially_parsed', {
      defaultMessage: 'Partially parsed'
    })
  },
  outcome_filter_skipped: {
    id: 'outcome_filter_skipped',
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.outcomeControls.skipped', {
      defaultMessage: 'Skipped'
    })
  },
  outcome_filter_failed: {
    id: 'outcome_filter_failed',
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.outcomeControls.failed', {
      defaultMessage: 'Failed'
    })
  }
};