"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setProcessorConfig = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _condition = require("../../../../../../util/condition");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultFormState = {
  type: 'set',
  field: '',
  value: '',
  ignore_failure: false,
  override: true,
  ignore_empty_value: false,
  media_type: '',
  if: _condition.ALWAYS_CONDITION
};
const fieldOptions = {
  fieldHelpText: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.setFieldHelpText', {
    defaultMessage: 'The field to insert, upsert, or update.'
  }),
  includeCondition: true,
  includeIgnoreFailures: true,
  includeIgnoreMissing: false
};
const fieldConfigurations = [{
  field: 'value',
  type: 'string',
  required: true,
  label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.setValueFieldLabel', {
    defaultMessage: 'Value'
  }),
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.setValueFieldHelpText",
    defaultMessage: "The value to be set for the field. Supports template snippets."
  })
}, {
  field: 'override',
  type: 'boolean',
  required: false,
  label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.setOverrideLabel', {
    defaultMessage: 'Override'
  }),
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.setOverrideHelpText",
    defaultMessage: "If true processor will update fields with pre-existing non-null-valued field. When set to false, such fields will not be touched."
  })
}, {
  field: 'ignore_empty_value',
  type: 'boolean',
  required: false,
  label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.setIgnoreEmptyValueLabel', {
    defaultMessage: 'Ignore empty value'
  }),
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.setIgnoreEmptyValueHelpText",
    defaultMessage: "If true and used in combination with {value} which is a template snippet that evaluates to null or an empty string, the processor quietly exits without modifying the document.",
    values: {
      value: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "value")
    }
  })
}, {
  field: 'media_type',
  type: 'string',
  required: false,
  label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.setMediaTypeLabel', {
    defaultMessage: 'Media type'
  }),
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.setMediaTypeHelpText",
    defaultMessage: "The media type for encoding value. Applies only when {value} is a template snippet. Must be one of application/json, text/plain, or application/x-www-form-urlencoded.",
    values: {
      value: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "value")
    }
  })
}];
const setProcessorConfig = exports.setProcessorConfig = {
  type: 'set',
  inputDisplay: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.setInputDisplay', {
    defaultMessage: 'Set'
  }),
  getDocUrl: esDocUrl => {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.setHelpText",
      defaultMessage: "{setLink} If the field already exists, its value will be replaced with the provided one.",
      values: {
        setLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "streamsAppAvailableProcessorsSetLink",
          external: true,
          target: "_blank",
          href: esDocUrl + 'set-processor.html'
        }, _i18n.i18n.translate('xpack.streams.availableProcessors.setLinkLabel', {
          defaultMessage: 'Sets one field and associates it with the specified value.'
        }))
      }
    });
  },
  defaultFormState,
  convertFormStateToConfig: (0, _utils.getConvertFormStateToConfig)('set', fieldConfigurations, fieldOptions),
  convertProcessorToFormState: (0, _utils.getConvertProcessorToFormState)('set', defaultFormState),
  fieldConfigurations,
  fieldOptions
};