"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertToFieldDefinitionConfig = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const convertToFieldDefinitionConfig = field => ({
  type: field.type,
  ...(field.format && field.type === 'date' ? {
    format: field.format
  } : {}),
  ...(field.additionalParameters && Object.keys(field.additionalParameters).length > 0 ? field.additionalParameters : {})
});
exports.convertToFieldDefinitionConfig = convertToFieldDefinitionConfig;