"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SchemaEditor = SchemaEditor;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_controls = require("./hooks/use_controls");
var _schema_editor_context = require("./schema_editor_context");
var _schema_editor_controls = require("./schema_editor_controls");
var _schema_editor_table = require("./schema_editor_table");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SchemaEditor({
  defaultColumns = _constants.SUPPORTED_TABLE_COLUMN_NAMES,
  fields,
  isLoading,
  onFieldUnmap,
  onFieldUpdate,
  onRefreshData,
  stream,
  withControls = false,
  withFieldSimulation = false,
  withTableActions = false,
  withToolbar = true
}) {
  const [controls, updateControls] = (0, _use_controls.useControls)();
  return /*#__PURE__*/_react.default.createElement(_schema_editor_context.SchemaEditorContextProvider, {
    fields: fields,
    isLoading: isLoading,
    onFieldUnmap: onFieldUnmap,
    onFieldUpdate: onFieldUpdate,
    stream: stream,
    withControls: withControls,
    withFieldSimulation: withFieldSimulation,
    withTableActions: withTableActions
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "fixed"
  })) : null, withControls && /*#__PURE__*/_react.default.createElement(_schema_editor_controls.Controls, {
    controls: controls,
    onChange: updateControls,
    onRefreshData: onRefreshData
  }), /*#__PURE__*/_react.default.createElement(_schema_editor_table.FieldsTable, {
    isLoading: isLoading !== null && isLoading !== void 0 ? isLoading : false,
    controls: controls,
    withToolbar: withToolbar,
    defaultColumns: defaultColumns,
    fields: fields,
    stream: stream,
    withTableActions: withTableActions
  })));
}