"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SchemaEditorFlyout = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _useAsyncFn = _interopRequireDefault(require("react-use/lib/useAsyncFn"));
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
var _sample_preview_table = require("./sample_preview_table");
var _field_summary = require("./field_summary");
var _advanced_field_mapping_options = require("./advanced_field_mapping_options");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SchemaEditorFlyout = ({
  field,
  stream,
  onClose,
  onSave,
  isEditingByDefault = false,
  withFieldSimulation = false
}) => {
  const [isEditing, toggleEditMode] = (0, _useToggle.default)(isEditingByDefault);
  const [isValidAdvancedFieldMappings, setValidAdvancedFieldMappings] = (0, _react.useState)(true);
  const [isValidSimulation, setValidSimulation] = (0, _react.useState)(true);
  const [nextField, setNextField] = (0, _react.useReducer)((prev, updated) => ({
    ...prev,
    ...updated
  }), field);
  const hasValidFieldType = nextField.type !== undefined;
  const [{
    loading: isSaving
  }, saveChanges] = (0, _useAsyncFn.default)(async () => {
    await onSave(nextField);
    if (onClose) onClose();
  }, [nextField, onClose, onSave]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, field.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_field_summary.FieldSummary, {
    field: nextField,
    isEditing: isEditing,
    toggleEditMode: toggleEditMode,
    onChange: setNextField,
    stream: stream
  }), /*#__PURE__*/_react.default.createElement(_advanced_field_mapping_options.AdvancedFieldMappingOptions, {
    field: nextField,
    onChange: setNextField,
    onValidate: setValidAdvancedFieldMappings,
    isEditing: isEditing
  }), withFieldSimulation && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_sample_preview_table.SamplePreviewTable, {
    stream: stream,
    nextField: nextField,
    onValidate: setValidSimulation
  })))), isEditing && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "streamsAppSchemaEditorFlyoutCloseButton",
    iconType: "cross",
    onClick: onClose,
    flush: "left"
  }, _i18n.i18n.translate('xpack.streams.schemaEditorFlyout.closeButtonLabel', {
    defaultMessage: 'Cancel'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "streamsAppSchemaEditorFieldSaveButton",
    disabled: isSaving || !hasValidFieldType || !isValidAdvancedFieldMappings || !isValidSimulation,
    isLoading: isSaving,
    onClick: saveChanges
  }, _i18n.i18n.translate('xpack.streams.fieldForm.saveButtonLabel', {
    defaultMessage: 'Save changes'
  })))));
};
exports.SchemaEditorFlyout = SchemaEditorFlyout;