"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldSummary = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _streamsSchema = require("@kbn/streams-schema");
var _use_streams_app_router = require("../../../../hooks/use_streams_app_router");
var _field_parent = require("../field_parent");
var _field_status = require("../field_status");
var _field_form_format = require("./field_form_format");
var _field_form_type = require("./field_form_type");
var _children_affected_callout = require("./children_affected_callout");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const title = _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldSummaryTitle', {
  defaultMessage: 'Field summary'
});
const FIELD_SUMMARIES = {
  fieldStatus: {
    label: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldSummaryFieldNameHeader', {
      defaultMessage: 'Status'
    })
  },
  fieldType: {
    label: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldSummaryFieldTypeHeader', {
      defaultMessage: 'Type'
    })
  },
  fieldFormat: {
    label: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldSummaryFieldFormatHeader', {
      defaultMessage: 'Format'
    })
  },
  fieldParent: {
    label: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldSummaryFieldParentHeader', {
      defaultMessage: 'Field Parent'
    })
  }
};
const FieldSummary = props => {
  var _field$format;
  const {
    field,
    isEditing,
    toggleEditMode,
    onChange,
    stream
  } = props;
  const router = (0, _use_streams_app_router.useStreamsAppRouter)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("span", null, title, " "))), field.status !== 'inherited' && !isEditing ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "streamsAppFieldSummaryEditButton",
    size: "s",
    color: "primary",
    onClick: toggleEditMode,
    iconType: "pencil"
  }, _i18n.i18n.translate('xpack.streams.fieldSummary.editButtonLabel', {
    defaultMessage: 'Edit'
  }))))) : field.status === 'inherited' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "streamsAppFieldSummaryOpenInParentButton",
    size: "s",
    color: "primary",
    iconType: "popout",
    href: router.link('/{key}/management/{tab}', {
      path: {
        key: field.parent,
        tab: 'schemaEditor'
      }
    }),
    target: "_blank"
  }, _i18n.i18n.translate('xpack.streams.fieldSummary.editInParentButtonLabel', {
    defaultMessage: 'Edit in parent stream'
  }))))) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("span", null, FIELD_SUMMARIES.fieldStatus.label, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    type: "info",
    color: "subdued",
    content: _i18n.i18n.translate('xpack.streams.fieldSummary.statusTooltip', {
      defaultMessage: 'Indicates whether the field is actively mapped for use in the configuration or remains unmapped and inactive.'
    })
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_field_status.FieldStatusBadge, {
    status: field.status
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("span", null, FIELD_SUMMARIES.fieldType.label))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_field_form_type.FieldFormType, {
    field: field,
    isEditing: isEditing,
    onTypeChange: type => onChange({
      type
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), (0, _field_form_format.typeSupportsFormat)(field.type) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("span", null, FIELD_SUMMARIES.fieldFormat.label))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, isEditing ? /*#__PURE__*/_react.default.createElement(_field_form_format.FieldFormFormat, {
    field: field,
    onChange: format => onChange({
      format
    })
  }) : `${(_field$format = field.format) !== null && _field$format !== void 0 ? _field$format : _constants.EMPTY_CONTENT}`)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("span", null, FIELD_SUMMARIES.fieldParent.label))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_field_parent.FieldParent, {
    parent: field.parent
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  })), isEditing && _streamsSchema.Streams.WiredStream.Definition.is(stream) && stream.ingest.wired.routing.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_children_affected_callout.ChildrenAffectedCallout, {
    childStreams: stream.ingest.wired.routing
  })) : null);
};
exports.FieldSummary = FieldSummary;