"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldType = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactField = require("@kbn/react-field");
var _i18n = require("@kbn/i18n");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FieldType = ({
  type,
  aliasFor
}) => {
  if (aliasFor) {
    return _i18n.i18n.translate('xpack.streams.fieldType.aliasFor', {
      defaultMessage: 'Alias for {aliasFor}',
      values: {
        aliasFor
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_reactField.FieldNameWithIcon, {
    name: _constants.FIELD_TYPE_MAP[type].label,
    type: type !== 'system' ? type : undefined
  });
};
exports.FieldType = FieldType;