"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.enrichmentUrlSchema = exports.customSamplesDataSourceSchema = exports.customSamplesDataSourceDocumentsSchema = void 0;
var _record_types = require("@kbn/streams-schema/src/shared/record_types");
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Base interface for all data source types with common properties
 */

/**
 * Base schema for common data source properties
 */
const baseDataSourceSchema = _zod.z.object({
  enabled: _zod.z.boolean(),
  name: _zod.z.string().optional()
});

/**
 * Random samples data source that retrieves data from the stream index
 */

const randomSamplesDataSourceSchema = baseDataSourceSchema.extend({
  type: _zod.z.literal('random-samples')
});

/**
 * KQL samples data source that retrieves data based on KQL query
 */

const kqlSamplesDataSourceSchema = baseDataSourceSchema.extend({
  type: _zod.z.literal('kql-samples'),
  query: _zod.z.object({
    language: _zod.z.string(),
    query: _zod.z.string()
  }),
  filters: _zod.z.array(_zod.z.any()).optional(),
  timeRange: _zod.z.object({
    from: _zod.z.string(),
    to: _zod.z.string()
  })
});

/**
 * Custom samples data source with user-provided documents
 */

const customSamplesDataSourceDocumentsSchema = exports.customSamplesDataSourceDocumentsSchema = _zod.z.array(_record_types.sampleDocument);
const customSamplesDataSourceSchema = exports.customSamplesDataSourceSchema = baseDataSourceSchema.extend({
  type: _zod.z.literal('custom-samples'),
  documents: customSamplesDataSourceDocumentsSchema
});

/**
 * Union type of all possible data source types
 */

/**
 * Schema for validating enrichment data sources
 */
const enrichmentDataSourceSchema = _zod.z.union([randomSamplesDataSourceSchema, kqlSamplesDataSourceSchema, customSamplesDataSourceSchema]);

/**
 * URL state for enrichment configuration
 */

/**
 * Schema for validating enrichment URL state
 */
const enrichmentUrlSchema = exports.enrichmentUrlSchema = _zod.z.object({
  v: _zod.z.literal(1),
  dataSources: _zod.z.array(enrichmentDataSourceSchema)
});