"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EmailParamsSchema", {
  enumerable: true,
  get: function () {
    return _email.ParamsSchema;
  }
});
Object.defineProperty(exports, "JiraParamsSchema", {
  enumerable: true,
  get: function () {
    return _schema3.ExecutorParamsSchema;
  }
});
Object.defineProperty(exports, "PagerdutyParamsSchema", {
  enumerable: true,
  get: function () {
    return _pagerduty.ParamsSchema;
  }
});
Object.defineProperty(exports, "SlackApiParamsSchema", {
  enumerable: true,
  get: function () {
    return _schema.SlackApiParamsSchema;
  }
});
Object.defineProperty(exports, "SlackParamsSchema", {
  enumerable: true,
  get: function () {
    return _slack.ParamsSchema;
  }
});
Object.defineProperty(exports, "WebhookParamsSchema", {
  enumerable: true,
  get: function () {
    return _schema2.ParamsSchema;
  }
});
exports.plugin = exports.config = void 0;
var _config = require("./config");
var _schema = require("../common/slack_api/schema");
var _slack = require("./connector_types/slack");
var _email = require("./connector_types/email");
var _schema2 = require("./connector_types/webhook/schema");
var _schema3 = require("./connector_types/jira/schema");
var _pagerduty = require("./connector_types/pagerduty");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const config = exports.config = {
  exposeToBrowser: {
    enableExperimental: true
  },
  schema: _config.configSchema
};
const plugin = async initContext => {
  const {
    StackConnectorsPlugin
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('./plugin')));
  return new StackConnectorsPlugin(initContext);
};
exports.plugin = plugin;