"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateGeminiSecrets = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateGeminiSecrets = secrets => {
  if (!secrets.credentialsJson) {
    throw new Error(_i18n.i18n.translate('xpack.stackConnectors.gemini.validation.missingCredentialsError', {
      defaultMessage: 'Google Service Account credentials JSON is required.'
    }));
  }
  let credentials;
  try {
    credentials = JSON.parse(secrets.credentialsJson);
  } catch (err) {
    throw new Error(_i18n.i18n.translate('xpack.stackConnectors.gemini.validation.invalidJsonError', {
      defaultMessage: 'Invalid JSON format for credentials.'
    }));
  }
  if (credentials.type !== 'service_account') {
    throw new Error(_i18n.i18n.translate('xpack.stackConnectors.gemini.validation.invalidCredentialTypeError', {
      defaultMessage: 'Invalid credential type. Only "service_account" credentials are supported. Type was "{type}".',
      values: {
        type: credentials.type
      }
    }));
  }
};
exports.validateGeminiSecrets = validateGeminiSecrets;