"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SW_SEVERITY_FIELD_LABEL = exports.SW_RULE_NAME_FIELD_LABEL = exports.SW_REQUIRED_SEVERITY = exports.SW_REQUIRED_RULE_NAME = exports.SW_REQUIRED_DESCRIPTION = exports.SW_REQUIRED_CONNECTOR_TYPE = exports.SW_REQUIRED_COMMENTS = exports.SW_REQUIRED_CASE_NAME = exports.SW_REQUIRED_CASE_ID = exports.SW_REQUIRED_APP_ID_TEXT = exports.SW_REQUIRED_API_TOKEN = exports.SW_REQUIRED_ALERT_ID = exports.SW_NEXT = exports.SW_MAPPING_TITLE_TEXT_FIELD_LABEL = exports.SW_GET_APPLICATION_API_NO_FIELDS_ERROR = exports.SW_GET_APPLICATION_API_ERROR = exports.SW_FIELDS_BUTTON_HELP_TEXT = exports.SW_DESCRIPTION_FIELD_LABEL = exports.SW_CONNECTOR_TYPE_LABEL = exports.SW_CONFIGURE_CONNECTION_LABEL = exports.SW_COMMENTS_FIELD_LABEL = exports.SW_CASE_NAME_FIELD_LABEL = exports.SW_CASE_ID_FIELD_LABEL = exports.SW_BACK = exports.SW_APP_ID_TEXT_FIELD_LABEL = exports.SW_API_URL_TEXT_FIELD_LABEL = exports.SW_API_URL_INVALID = exports.SW_API_TOKEN_TEXT_FIELD_LABEL = exports.SW_ALERT_ID_FIELD_LABEL = exports.EMPTY_MAPPING_WARNING_TITLE = exports.EMPTY_MAPPING_WARNING_DESC = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SW_REQUIRED_RULE_NAME = exports.SW_REQUIRED_RULE_NAME = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.error.requiredRuleName', {
  defaultMessage: 'Rule name is required.'
});
const SW_REQUIRED_APP_ID_TEXT = exports.SW_REQUIRED_APP_ID_TEXT = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.error.requiredAppIdText', {
  defaultMessage: 'An App ID is required.'
});
const SW_GET_APPLICATION_API_ERROR = id => _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.unableToGetApplicationMessage', {
  defaultMessage: 'Unable to get application with id {id}',
  values: {
    id
  }
});
exports.SW_GET_APPLICATION_API_ERROR = SW_GET_APPLICATION_API_ERROR;
const SW_GET_APPLICATION_API_NO_FIELDS_ERROR = exports.SW_GET_APPLICATION_API_NO_FIELDS_ERROR = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.unableToGetApplicationFieldsMessage', {
  defaultMessage: 'Unable to get application fields'
});
const SW_API_URL_TEXT_FIELD_LABEL = exports.SW_API_URL_TEXT_FIELD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.apiUrlTextFieldLabel', {
  defaultMessage: 'API Url'
});
const SW_API_URL_INVALID = exports.SW_API_URL_INVALID = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.invalidApiUrlTextField', {
  defaultMessage: 'URL is invalid.'
});
const SW_APP_ID_TEXT_FIELD_LABEL = exports.SW_APP_ID_TEXT_FIELD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.appIdTextFieldLabel', {
  defaultMessage: 'Application ID'
});
const SW_API_TOKEN_TEXT_FIELD_LABEL = exports.SW_API_TOKEN_TEXT_FIELD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.apiTokenTextFieldLabel', {
  defaultMessage: 'API Token'
});
const SW_MAPPING_TITLE_TEXT_FIELD_LABEL = exports.SW_MAPPING_TITLE_TEXT_FIELD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.mappingTitleTextFieldLabel', {
  defaultMessage: 'Configure Field Mappings'
});
const SW_SEVERITY_FIELD_LABEL = exports.SW_SEVERITY_FIELD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.severityFieldLabel', {
  defaultMessage: 'Severity'
});
const SW_RULE_NAME_FIELD_LABEL = exports.SW_RULE_NAME_FIELD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.ruleNameFieldLabel', {
  defaultMessage: 'Rule name'
});
const SW_ALERT_ID_FIELD_LABEL = exports.SW_ALERT_ID_FIELD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.alertIdFieldLabel', {
  defaultMessage: 'Alert ID'
});
const SW_CASE_ID_FIELD_LABEL = exports.SW_CASE_ID_FIELD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.caseIdFieldLabel', {
  defaultMessage: 'Case ID'
});
const SW_CASE_NAME_FIELD_LABEL = exports.SW_CASE_NAME_FIELD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.caseNameFieldLabel', {
  defaultMessage: 'Case name'
});
const SW_COMMENTS_FIELD_LABEL = exports.SW_COMMENTS_FIELD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.commentsFieldLabel', {
  defaultMessage: 'Comments'
});
const SW_DESCRIPTION_FIELD_LABEL = exports.SW_DESCRIPTION_FIELD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.descriptionFieldLabel', {
  defaultMessage: 'Description'
});
const SW_CONFIGURE_CONNECTION_LABEL = exports.SW_CONFIGURE_CONNECTION_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.configureConnectionLabel', {
  defaultMessage: 'Configure API Connection'
});
const SW_CONNECTOR_TYPE_LABEL = exports.SW_CONNECTOR_TYPE_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.connectorType', {
  defaultMessage: 'Connector Type'
});
const EMPTY_MAPPING_WARNING_TITLE = exports.EMPTY_MAPPING_WARNING_TITLE = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.emptyMappingWarningTitle', {
  defaultMessage: 'This connector has missing field mappings'
});
const EMPTY_MAPPING_WARNING_DESC = exports.EMPTY_MAPPING_WARNING_DESC = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.emptyMappingWarningDesc', {
  defaultMessage: 'This connector cannot be selected because it is missing the required alert field mappings. You can edit this connector to add required field mappings or select a connector of type Alerts.'
});
const SW_REQUIRED_SEVERITY = exports.SW_REQUIRED_SEVERITY = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.error.requiredSeverity', {
  defaultMessage: 'Severity is required.'
});
const SW_REQUIRED_CASE_NAME = exports.SW_REQUIRED_CASE_NAME = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.error.requiredCaseName', {
  defaultMessage: 'Case name is required.'
});
const SW_REQUIRED_CASE_ID = exports.SW_REQUIRED_CASE_ID = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.error.requiredCaseID', {
  defaultMessage: 'Case ID is required.'
});
const SW_REQUIRED_COMMENTS = exports.SW_REQUIRED_COMMENTS = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.error.requiredComments', {
  defaultMessage: 'Comments are required.'
});
const SW_REQUIRED_DESCRIPTION = exports.SW_REQUIRED_DESCRIPTION = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.error.requiredDescription', {
  defaultMessage: 'Description is required.'
});
const SW_REQUIRED_ALERT_ID = exports.SW_REQUIRED_ALERT_ID = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.error.requiredAlertID', {
  defaultMessage: 'Alert ID is required.'
});
const SW_REQUIRED_API_TOKEN = exports.SW_REQUIRED_API_TOKEN = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.error.requiredApiToken', {
  defaultMessage: 'API Token is required.'
});
const SW_REQUIRED_CONNECTOR_TYPE = exports.SW_REQUIRED_CONNECTOR_TYPE = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.error.requiredConnectorType', {
  defaultMessage: 'Connector Type is required.'
});
const SW_BACK = exports.SW_BACK = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.prevStep', {
  defaultMessage: 'Back'
});
const SW_NEXT = exports.SW_NEXT = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.nextStep', {
  defaultMessage: 'Next'
});
const SW_FIELDS_BUTTON_HELP_TEXT = exports.SW_FIELDS_BUTTON_HELP_TEXT = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.nextStepHelpText', {
  defaultMessage: 'If field mappings are not configured, Swimlane connector type will be set to all.'
});