"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var i18n = _interopRequireWildcard(require("./translations"));
var _types = require("./types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SwimlaneParamsFields = ({
  actionParams,
  editAction,
  index,
  messageVariables,
  actionConnector
}) => {
  var _actionConnector$id, _incident$severity;
  const {
    incident,
    comments
  } = (0, _react.useMemo)(() => {
    var _actionParams$subActi;
    return (_actionParams$subActi = actionParams.subActionParams) !== null && _actionParams$subActi !== void 0 ? _actionParams$subActi : {
      incident: {},
      comments: []
    };
  }, [actionParams.subActionParams]);
  const actionConnectorRef = (0, _react.useRef)((_actionConnector$id = actionConnector === null || actionConnector === void 0 ? void 0 : actionConnector.id) !== null && _actionConnector$id !== void 0 ? _actionConnector$id : '');
  const {
    mappings,
    connectorType
  } = actionConnector.config;
  const {
    hasAlertId,
    hasRuleName,
    hasComments,
    hasSeverity
  } = (0, _react.useMemo)(() => ({
    hasAlertId: mappings.alertIdConfig != null,
    hasRuleName: mappings.ruleNameConfig != null,
    hasComments: mappings.commentsConfig != null,
    hasSeverity: mappings.severityConfig != null
  }), [mappings.alertIdConfig, mappings.ruleNameConfig, mappings.commentsConfig, mappings.severityConfig]);

  /**
   * The user can use either a connector of type alerts or all.
   * If the connector is of type all we should check if all
   * required field have been configured.
   */
  const showMappingWarning = connectorType === _types.SwimlaneConnectorType.Cases || !hasRuleName || !hasAlertId;
  const editSubActionProperty = (0, _react.useCallback)((key, value) => {
    if (key === 'comments') {
      return editAction('subActionParams', {
        incident,
        comments: value
      }, index);
    }
    return editAction('subActionParams', {
      incident: {
        ...incident,
        [key]: value
      },
      comments
    }, index);
  }, [editAction, incident, comments, index]);
  const editComment = (0, _react.useCallback)((key, value) => {
    editSubActionProperty(key, [{
      commentId: '1',
      comment: value
    }]);
  }, [editSubActionProperty]);
  (0, _react.useEffect)(() => {
    if (actionConnector != null && actionConnectorRef.current !== actionConnector.id) {
      actionConnectorRef.current = actionConnector.id;
      editAction('subActionParams', {
        incident: {
          alertId: '{{alert.id}}',
          ruleName: '{{rule.name}}'
        },
        comments: []
      }, index);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [actionConnector]);
  (0, _react.useEffect)(() => {
    if (!actionParams.subAction) {
      editAction('subAction', 'pushToService', index);
    }
    if (!actionParams.subActionParams) {
      editAction('subActionParams', {
        incident: {
          alertId: '{{alert.id}}',
          ruleName: '{{rule.name}}'
        },
        comments: []
      }, index);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [actionParams]);
  return !showMappingWarning ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasSeverity && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.SW_SEVERITY_FIELD_LABEL
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    "data-test-subj": "severity",
    editAction: editSubActionProperty,
    messageVariables: messageVariables,
    paramsProperty: 'severity',
    inputTargetValue: (_incident$severity = incident.severity) !== null && _incident$severity !== void 0 ? _incident$severity : undefined
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), hasComments && /*#__PURE__*/_react.default.createElement(_public.TextAreaWithMessageVariables, {
    "data-test-subj": "comments",
    index: index,
    editAction: editComment,
    messageVariables: messageVariables,
    paramsProperty: 'comments',
    inputTargetValue: comments && comments.length > 0 ? comments[0].comment : undefined,
    label: i18n.SW_COMMENTS_FIELD_LABEL
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18n.EMPTY_MAPPING_WARNING_TITLE,
    color: "warning",
    iconType: "question"
  }, i18n.EMPTY_MAPPING_WARNING_DESC);
};

// eslint-disable-next-line import/no-default-export
exports.default = SwimlaneParamsFields;
module.exports = exports.default;