"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SEVERITY_API_ERROR = exports.ORG_ID_LABEL = exports.NAME_REQUIRED = exports.INCIDENT_TYPES_API_ERROR = exports.API_URL_LABEL = exports.API_KEY_SECRET_LABEL = exports.API_KEY_ID_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const API_URL_LABEL = exports.API_URL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.resilient.apiUrlTextFieldLabel', {
  defaultMessage: 'URL'
});
const ORG_ID_LABEL = exports.ORG_ID_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.resilient.orgId', {
  defaultMessage: 'Organization ID'
});
const API_KEY_ID_LABEL = exports.API_KEY_ID_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.resilient.apiKeyId', {
  defaultMessage: 'API key ID'
});
const API_KEY_SECRET_LABEL = exports.API_KEY_SECRET_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.resilient.apiKeySecret', {
  defaultMessage: 'API key secret'
});
const NAME_REQUIRED = exports.NAME_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.resilient.requiredNameTextField', {
  defaultMessage: 'Name is required.'
});
const INCIDENT_TYPES_API_ERROR = exports.INCIDENT_TYPES_API_ERROR = _i18n.i18n.translate('xpack.stackConnectors.components.resilient.unableToGetIncidentTypesMessage', {
  defaultMessage: 'Unable to get incident types'
});
const SEVERITY_API_ERROR = exports.SEVERITY_API_ERROR = _i18n.i18n.translate('xpack.stackConnectors.components.resilient.unableToGetSeverityMessage', {
  defaultMessage: 'Unable to get severity'
});