"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VERIFICATION_MODE_LABEL = exports.VALUE_LABEL = exports.USERNAME_REQUIRED = exports.USERNAME = exports.PFX_REQUIRED = exports.PASSWORD_REQUIRED = exports.PASSWORD = exports.KEY_REQUIRED = exports.KEY_LABEL = exports.HEADERS_TITLE = exports.HEADERS_SWITCH = exports.EDIT_CA_CALLOUT = exports.DELETE_BUTTON = exports.CRT_REQUIRED = exports.CERT_TYPE_PFX = exports.CERT_TYPE_CRT_KEY = exports.CA_REQUIRED = exports.AUTHENTICATION_TITLE = exports.AUTHENTICATION_SSL = exports.AUTHENTICATION_NONE = exports.AUTHENTICATION_BASIC = exports.ADD_CA_LABEL = exports.ADD_BUTTON = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AUTHENTICATION_TITLE = exports.AUTHENTICATION_TITLE = _i18n.i18n.translate('xpack.stackConnectors.components.auth.authenticationTitle', {
  defaultMessage: 'Authentication'
});
const AUTHENTICATION_NONE = exports.AUTHENTICATION_NONE = _i18n.i18n.translate('xpack.stackConnectors.components.auth.authenticationMethodNoneLabel', {
  defaultMessage: 'None'
});
const AUTHENTICATION_BASIC = exports.AUTHENTICATION_BASIC = _i18n.i18n.translate('xpack.stackConnectors.components.auth.authenticationMethodBasicLabel', {
  defaultMessage: 'Basic authentication'
});
const AUTHENTICATION_SSL = exports.AUTHENTICATION_SSL = _i18n.i18n.translate('xpack.stackConnectors.components.auth.authenticationMethodSSLLabel', {
  defaultMessage: 'SSL authentication'
});
const USERNAME = exports.USERNAME = _i18n.i18n.translate('xpack.stackConnectors.components.auth.userTextFieldLabel', {
  defaultMessage: 'Username'
});
const PASSWORD = exports.PASSWORD = _i18n.i18n.translate('xpack.stackConnectors.components.auth.passwordTextFieldLabel', {
  defaultMessage: 'Password'
});
const USERNAME_REQUIRED = exports.USERNAME_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.auth.error.requiredAuthUserNameText', {
  defaultMessage: 'Username is required.'
});
const PASSWORD_REQUIRED = exports.PASSWORD_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.auth.error.requiredAuthPasswordText', {
  defaultMessage: 'Password is required.'
});
const CERT_TYPE_CRT_KEY = exports.CERT_TYPE_CRT_KEY = _i18n.i18n.translate('xpack.stackConnectors.components.auth.certTypeCrtKeyLabel', {
  defaultMessage: 'CRT and KEY file'
});
const CERT_TYPE_PFX = exports.CERT_TYPE_PFX = _i18n.i18n.translate('xpack.stackConnectors.components.auth.certTypePfxLabel', {
  defaultMessage: 'PFX file'
});
const CRT_REQUIRED = exports.CRT_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.auth.error.requiredCRTText', {
  defaultMessage: 'CRT file is required.'
});
const KEY_REQUIRED = exports.KEY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.auth.error.requiredKEYText', {
  defaultMessage: 'KEY file is required.'
});
const PFX_REQUIRED = exports.PFX_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.auth.error.requiredPFXText', {
  defaultMessage: 'PFX file is required.'
});
const HEADERS_SWITCH = exports.HEADERS_SWITCH = _i18n.i18n.translate('xpack.stackConnectors.components.auth.viewHeadersSwitch', {
  defaultMessage: 'Add HTTP header'
});
const HEADERS_TITLE = exports.HEADERS_TITLE = _i18n.i18n.translate('xpack.stackConnectors.components.auth.httpHeadersTitle', {
  defaultMessage: 'Headers in use'
});
const KEY_LABEL = exports.KEY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.auth.keyTextFieldLabel', {
  defaultMessage: 'Key'
});
const VALUE_LABEL = exports.VALUE_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.auth.valueTextFieldLabel', {
  defaultMessage: 'Value'
});
const ADD_BUTTON = exports.ADD_BUTTON = _i18n.i18n.translate('xpack.stackConnectors.components.auth.addHeaderButton', {
  defaultMessage: 'Add'
});
const DELETE_BUTTON = exports.DELETE_BUTTON = _i18n.i18n.translate('xpack.stackConnectors.components.auth.deleteHeaderButton', {
  defaultMessage: 'Delete',
  description: 'Delete HTTP header'
});
const CA_REQUIRED = exports.CA_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.auth.error.requiredCAText', {
  defaultMessage: 'CA file is required.'
});
const ADD_CA_LABEL = exports.ADD_CA_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.auth.viewCertificateAuthoritySwitch', {
  defaultMessage: 'Add certificate authority'
});
const VERIFICATION_MODE_LABEL = exports.VERIFICATION_MODE_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.auth.verificationModeFieldLabel', {
  defaultMessage: 'Verification mode'
});
const EDIT_CA_CALLOUT = exports.EDIT_CA_CALLOUT = _i18n.i18n.translate('xpack.stackConnectors.components.auth.editCACallout', {
  defaultMessage: 'This connector has an existing certificate authority file. Upload a new one to replace it.'
});