"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpacesPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _capabilities = require("./capabilities");
var _default_space = require("./default_space");
var _request_interceptors = require("./lib/request_interceptors");
var _spaces_tutorial_context_factory = require("./lib/spaces_tutorial_context_factory");
var _external = require("./routes/api/external");
var _internal = require("./routes/api/internal");
var _views = require("./routes/views");
var _saved_objects = require("./saved_objects");
var _spaces_client = require("./spaces_client");
var _spaces_service = require("./spaces_service");
var _ui_settings = require("./ui_settings");
var _usage_collection = require("./usage_collection");
var _usage_stats = require("./usage_stats");
var _licensing = require("../common/licensing");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Setup contract for the Spaces plugin.
 */

/**
 * Start contract for the Spaces plugin.
 */

class SpacesPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "config$", void 0);
    (0, _defineProperty2.default)(this, "log", void 0);
    (0, _defineProperty2.default)(this, "spacesLicenseService", new _licensing.SpacesLicenseService());
    (0, _defineProperty2.default)(this, "spacesClientService", void 0);
    (0, _defineProperty2.default)(this, "spacesService", void 0);
    (0, _defineProperty2.default)(this, "hasOnlyDefaultSpace$", void 0);
    (0, _defineProperty2.default)(this, "spacesServiceStart", void 0);
    (0, _defineProperty2.default)(this, "defaultSpaceService", void 0);
    this.initializerContext = initializerContext;
    this.config$ = initializerContext.config.create();
    this.hasOnlyDefaultSpace$ = this.config$.pipe((0, _rxjs.map)(({
      maxSpaces
    }) => maxSpaces === 1));
    this.log = initializerContext.logger.get();
    this.spacesService = new _spaces_service.SpacesService();
    this.spacesClientService = new _spaces_client.SpacesClientService(message => this.log.debug(message), initializerContext.env.packageInfo.buildFlavor);
  }
  setup(core, plugins) {
    var _plugins$cloud, _plugins$cloud$onboar;
    const spacesClientSetup = this.spacesClientService.setup({
      config$: this.config$
    });
    core.uiSettings.registerGlobal((0, _ui_settings.getUiSettings)());
    const spacesServiceSetup = this.spacesService.setup({
      basePath: core.http.basePath
    });
    const getSpacesService = () => {
      if (!this.spacesServiceStart) {
        throw new Error('spaces service has not been initialized!');
      }
      return this.spacesServiceStart;
    };
    const usageStatsServicePromise = new _usage_stats.UsageStatsService(this.log).setup({
      getStartServices: core.getStartServices
    });
    const savedObjectsService = new _saved_objects.SpacesSavedObjectsService();
    savedObjectsService.setup({
      core,
      getSpacesService
    });
    const {
      license
    } = this.spacesLicenseService.setup({
      license$: plugins.licensing.license$
    });
    let defaultSolution;
    this.config$.pipe((0, _rxjs.take)(1)).subscribe(config => {
      defaultSolution = config.defaultSolution;
    });
    this.defaultSpaceService = new _default_space.DefaultSpaceService();
    this.defaultSpaceService.setup({
      coreStatus: core.status,
      getSavedObjects: async () => (await core.getStartServices())[0].savedObjects,
      license$: plugins.licensing.license$,
      spacesLicense: license,
      logger: this.log,
      solution: ((_plugins$cloud = plugins.cloud) === null || _plugins$cloud === void 0 ? void 0 : (_plugins$cloud$onboar = _plugins$cloud.onboarding) === null || _plugins$cloud$onboar === void 0 ? void 0 : _plugins$cloud$onboar.defaultSolution) || defaultSolution
    });
    (0, _views.initSpacesViewsRoutes)({
      httpResources: core.http.resources,
      basePath: core.http.basePath,
      logger: this.log
    });
    const router = core.http.createRouter();
    (0, _external.initExternalSpacesApi)({
      router,
      log: this.log,
      getStartServices: core.getStartServices,
      getSpacesService,
      usageStatsServicePromise,
      isServerless: this.initializerContext.env.packageInfo.buildFlavor === 'serverless'
    });
    (0, _internal.initInternalSpacesApi)({
      router,
      getSpacesService
    });
    (0, _request_interceptors.initSpacesRequestInterceptors)({
      http: core.http,
      log: this.log,
      getSpacesService,
      getFeatures: async () => (await core.getStartServices())[1].features
    });
    (0, _capabilities.setupCapabilities)(core, getSpacesService, this.log);
    if (plugins.usageCollection) {
      const getIndexForType = type => core.getStartServices().then(([coreStart]) => coreStart.savedObjects.getIndexForType(type));
      (0, _usage_collection.registerSpacesUsageCollector)(plugins.usageCollection, {
        getIndexForType,
        features: plugins.features,
        licensing: plugins.licensing,
        usageStatsServicePromise
      });
    }
    if (plugins.home) {
      plugins.home.tutorials.addScopedTutorialContextFactory((0, _spaces_tutorial_context_factory.createSpacesTutorialContextFactory)(getSpacesService));
    }
    return {
      spacesClient: spacesClientSetup,
      spacesService: spacesServiceSetup,
      hasOnlyDefaultSpace$: this.hasOnlyDefaultSpace$
    };
  }
  start(core, plugins) {
    const spacesClientStart = this.spacesClientService.start(core, plugins.features);
    this.spacesServiceStart = this.spacesService.start({
      basePath: core.http.basePath,
      spacesClientService: spacesClientStart
    });
    return {
      spacesService: this.spacesServiceStart,
      hasOnlyDefaultSpace$: this.hasOnlyDefaultSpace$
    };
  }
  stop() {
    if (this.defaultSpaceService) {
      this.defaultSpaceService.stop();
    }
  }
}
exports.SpacesPlugin = SpacesPlugin;