"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateSpacePage = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/es-ui-shared-plugin/public");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../common/constants");
var _constants2 = require("../../constants");
var _space_avatar = require("../../space_avatar");
var _components = require("../components");
var _confirm_alter_active_space_modal = require("../components/confirm_alter_active_space_modal");
var _customize_avatar = require("../components/customize_avatar");
var _customize_space = require("../components/customize_space");
var _enabled_features = require("../components/enabled_features");
var _solution_view = require("../components/solution_view");
var _lib = require("../lib");
var _validate_space = require("../lib/validate_space");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CreateSpacePage extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "validator", void 0);
    (0, _defineProperty2.default)(this, "getLoadingIndicator", () => /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
      alignment: "center",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_public.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.manageSpacePage.loadingMessage",
      defaultMessage: "Loading\u2026"
    }))));
    (0, _defineProperty2.default)(this, "getForm", () => {
      const {
        showAlteringActiveSpaceDialog
      } = this.state;
      return /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": "spaces-create-page"
      }, /*#__PURE__*/_react.default.createElement(_customize_space.CustomizeSpace, {
        space: this.state.space,
        onChange: this.onSpaceChange,
        editingExistingSpace: false,
        validator: this.validator
      }), !!this.props.allowSolutionVisibility && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "l"
      }), /*#__PURE__*/_react.default.createElement(_solution_view.SolutionView, {
        space: this.state.space,
        onChange: this.onSolutionViewChange,
        validator: this.validator,
        isEditing: false
      })), this.props.allowFeatureVisibility && (!this.state.space.solution || this.state.space.solution === _constants.SOLUTION_VIEW_CLASSIC) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_enabled_features.EnabledFeatures, {
        space: this.state.space,
        features: this.state.features,
        onChange: this.onSpaceChange
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_customize_avatar.CustomizeAvatar, {
        space: this.state.space,
        onChange: this.onSpaceChange,
        validator: this.validator
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), this.getChangeImpactWarning(), this.getFormButtons(), showAlteringActiveSpaceDialog && /*#__PURE__*/_react.default.createElement(_confirm_alter_active_space_modal.ConfirmAlterActiveSpaceModal, {
        onConfirm: () => this.performSave(true),
        onCancel: () => {
          this.setState({
            showAlteringActiveSpaceDialog: false
          });
        }
      }));
    });
    (0, _defineProperty2.default)(this, "getTitle", () => {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.spaces.management.manageSpacePage.createSpaceTitle",
        defaultMessage: "Create space"
      });
    });
    (0, _defineProperty2.default)(this, "getChangeImpactWarning", () => {
      const {
        haveDisabledFeaturesChanged,
        hasSolutionViewChanged
      } = this.state;
      if (!haveDisabledFeaturesChanged && !hasSolutionViewChanged) return null;
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        color: "warning",
        iconType: "warning",
        title: _i18n.i18n.translate('xpack.spaces.management.manageSpacePage.userImpactWarningTitle', {
          defaultMessage: 'Warning'
        }),
        "data-test-subj": "userImpactWarning"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.spaces.management.manageSpacePage.userImpactWarningDescription",
        defaultMessage: "The changes made will impact all users in the space."
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
    });
    (0, _defineProperty2.default)(this, "getFormButtons", () => {
      const createSpaceText = _i18n.i18n.translate('xpack.spaces.management.manageSpacePage.createSpaceButton', {
        defaultMessage: 'Create space'
      });
      const cancelButtonText = _i18n.i18n.translate('xpack.spaces.management.manageSpacePage.cancelSpaceButton', {
        defaultMessage: 'Cancel'
      });
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        responsive: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        fill: true,
        onClick: this.saveSpace,
        "data-test-subj": "save-space-button",
        isLoading: this.state.saveInProgress
      }, createSpaceText)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        onClick: this.backToSpacesList,
        "data-test-subj": "cancel-space-button"
      }, cancelButtonText)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: true
      }));
    });
    (0, _defineProperty2.default)(this, "onSolutionViewChange", space => {
      this.setState(state => ({
        ...state,
        solution: space.solution
      }));
      this.onSpaceChange(space);
    });
    (0, _defineProperty2.default)(this, "onSpaceChange", updatedSpace => {
      this.setState({
        space: updatedSpace
      });
    });
    (0, _defineProperty2.default)(this, "saveSpace", () => {
      this.validator.enableValidation();
      const space = this.state.space;
      const result = this.validator.validateForSave(space, false, this.props.allowSolutionVisibility);
      if (result.isInvalid) {
        this.setState({
          formError: result
        });
        return;
      }
      this.performSave();
    });
    (0, _defineProperty2.default)(this, "loadSpace", async (spaceId, featuresPromise) => {
      const {
        spacesManager,
        onLoadSpace
      } = this.props;
      try {
        const [space, features] = await Promise.all([spacesManager.getSpace(spaceId), featuresPromise]);
        if (space) {
          if (onLoadSpace) {
            onLoadSpace(space);
          }
          this.setState({
            space: {
              ...space,
              avatarType: space.imageUrl ? 'image' : 'initials',
              initials: space.initials || (0, _space_avatar.getSpaceInitials)(space),
              color: space.color || (0, _space_avatar.getSpaceColor)(space),
              customIdentifier: false,
              customAvatarInitials: !!space.initials && (0, _space_avatar.getSpaceInitials)({
                name: space.name
              }) !== space.initials,
              customAvatarColor: !!space.color && (0, _space_avatar.getSpaceColor)({
                name: space.name
              }) !== space.color
            },
            features,
            originalSpace: space,
            isLoading: false
          });
        }
      } catch (error) {
        var _error$body$message, _error$body;
        const message = (_error$body$message = error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : '';
        this.props.notifications.toasts.addDanger(_i18n.i18n.translate('xpack.spaces.management.manageSpacePage.errorLoadingSpaceTitle', {
          defaultMessage: 'Error loading space: {message}',
          values: {
            message
          }
        }));
        this.backToSpacesList();
      }
    });
    (0, _defineProperty2.default)(this, "performSave", (requireRefresh = false) => {
      if (!this.state.space) {
        return;
      }
      const name = this.state.space.name || '';
      const {
        id = (0, _lib.toSpaceIdentifier)(name),
        description,
        initials,
        color,
        disabledFeatures = [],
        imageUrl,
        avatarType,
        solution
      } = this.state.space;
      const params = {
        name,
        id,
        description,
        initials: avatarType !== 'image' ? initials : '',
        color: color ? (0, _eui.hsvToHex)((0, _eui.hexToHsv)(color)).toUpperCase() : color,
        // Convert 3 digit hex codes to 6 digits since Spaces API requires 6 digits
        disabledFeatures,
        imageUrl: avatarType === 'image' ? imageUrl : '',
        solution
      };
      const {
        spacesManager,
        eventTracker
      } = this.props;
      const action = spacesManager.createSpace(params);
      this.setState({
        saveInProgress: true
      });
      const trackSpaceSolutionChange = () => {
        var _this$state$originalS, _this$state$originalS2;
        const hasChangedSolution = ((_this$state$originalS = this.state.originalSpace) === null || _this$state$originalS === void 0 ? void 0 : _this$state$originalS.solution) !== solution;
        if (!hasChangedSolution || solution === undefined) return;
        eventTracker.spaceSolutionChanged({
          spaceId: id,
          solution,
          solutionPrev: (_this$state$originalS2 = this.state.originalSpace) === null || _this$state$originalS2 === void 0 ? void 0 : _this$state$originalS2.solution,
          action: 'create'
        });
      };
      action.then(() => {
        this.props.notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.spaces.management.manageSpacePage.spaceSuccessfullySavedNotificationMessage', {
          defaultMessage: `Space {name} was saved.`,
          values: {
            name: `'${name}'`
          }
        }));
        trackSpaceSolutionChange();
        this.backToSpacesList();
        if (requireRefresh) {
          var _window$__kbnAnalytic, _window$__kbnAnalytic2;
          const flushAnalyticsEvents = (_window$__kbnAnalytic = (_window$__kbnAnalytic2 = window.__kbnAnalytics) === null || _window$__kbnAnalytic2 === void 0 ? void 0 : _window$__kbnAnalytic2.flush) !== null && _window$__kbnAnalytic !== void 0 ? _window$__kbnAnalytic : () => Promise.resolve();
          flushAnalyticsEvents().then(() => {
            setTimeout(() => {
              window.location.reload();
            });
          });
        }
      }).catch(error => {
        var _error$body$message2, _error$body2;
        const message = (_error$body$message2 = error === null || error === void 0 ? void 0 : (_error$body2 = error.body) === null || _error$body2 === void 0 ? void 0 : _error$body2.message) !== null && _error$body$message2 !== void 0 ? _error$body$message2 : '';
        this.setState({
          saveInProgress: false
        });
        this.props.notifications.toasts.addDanger(_i18n.i18n.translate('xpack.spaces.management.manageSpacePage.errorSavingSpaceTitle', {
          defaultMessage: 'Error saving space: {message}',
          values: {
            message
          }
        }));
      });
    });
    (0, _defineProperty2.default)(this, "backToSpacesList", () => this.props.history.push('/'));
    this.validator = new _validate_space.SpaceValidator({
      shouldValidate: false
    });
    this.state = {
      isLoading: true,
      showAlteringActiveSpaceDialog: false,
      saveInProgress: false,
      space: {
        color: (0, _space_avatar.getSpaceColor)({})
      },
      features: [],
      haveDisabledFeaturesChanged: false,
      hasSolutionViewChanged: false
    };
  }
  async componentDidMount() {
    if (!this.props.capabilities.spaces.manage) {
      return;
    }
    const {
      spaceId,
      getFeatures,
      notifications
    } = this.props;
    try {
      if (spaceId) {
        await this.loadSpace(spaceId, getFeatures());
      } else {
        const features = await getFeatures();
        this.setState({
          isLoading: false,
          features
        });
      }
    } catch (e) {
      notifications.toasts.addError(e, {
        title: _i18n.i18n.translate('xpack.spaces.management.manageSpacePage.loadErrorTitle', {
          defaultMessage: 'Error loading available features'
        })
      });
    }
  }
  async componentDidUpdate(previousProps, prevState) {
    const {
      originalSpace,
      space
    } = this.state;
    if (originalSpace && space) {
      let haveDisabledFeaturesChanged = prevState.haveDisabledFeaturesChanged;
      if (prevState.space.disabledFeatures !== space.disabledFeatures) {
        var _space$disabledFeatur, _originalSpace$disabl, _originalSpace$disabl2;
        haveDisabledFeaturesChanged = ((_space$disabledFeatur = space.disabledFeatures) === null || _space$disabledFeatur === void 0 ? void 0 : _space$disabledFeatur.length) !== ((_originalSpace$disabl = originalSpace.disabledFeatures) === null || _originalSpace$disabl === void 0 ? void 0 : _originalSpace$disabl.length) || (0, _lodash.difference)(space.disabledFeatures, (_originalSpace$disabl2 = originalSpace.disabledFeatures) !== null && _originalSpace$disabl2 !== void 0 ? _originalSpace$disabl2 : []).length > 0;
      }
      const hasSolutionViewChanged = originalSpace.solution !== undefined ? space.solution !== originalSpace.solution : !!space.solution && space.solution !== 'classic';
      if (prevState.haveDisabledFeaturesChanged !== haveDisabledFeaturesChanged || prevState.hasSolutionViewChanged !== hasSolutionViewChanged) {
        this.setState({
          haveDisabledFeaturesChanged,
          hasSolutionViewChanged
        });
      }
    }
    if (this.props.spaceId !== previousProps.spaceId && this.props.spaceId) {
      await this.loadSpace(this.props.spaceId, Promise.resolve(this.state.features));
    }
  }
  render() {
    if (!this.props.capabilities.spaces.manage) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
        alignment: "center",
        color: "danger"
      }, /*#__PURE__*/_react.default.createElement(_components.UnauthorizedPrompt, null));
    }
    if (this.state.isLoading) {
      return this.getLoadingIndicator();
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
      restrictWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
      pageTitle: this.getTitle(),
      description: (0, _constants2.getSpacesFeatureDescription)()
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), this.getForm());
  }
}
exports.CreateSpacePage = CreateSpacePage;