"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyAdd = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _common = require("../../../../common");
var _shared_imports = require("../../../shared_imports");
var _components = require("../../components");
var _constants = require("../../constants");
var _navigation = require("../../services/navigation");
var _http = require("../../services/http");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PolicyAdd = ({
  history,
  location: {
    pathname
  }
}) => {
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const [saveError, setSaveError] = (0, _react.useState)(null);
  const {
    error: errorLoadingIndices,
    isLoading: isLoadingIndices,
    data
  } = (0, _http.useLoadIndices)();
  const {
    indices,
    dataStreams
  } = data !== null && data !== void 0 ? data : {
    indices: [],
    dataStreams: []
  };

  // Set breadcrumb and page title
  (0, _react.useEffect)(() => {
    _navigation.breadcrumbService.setBreadcrumbs('policyAdd');
    _navigation.docTitleService.setTitle('policyAdd');
  }, []);
  const onSave = async newPolicy => {
    setIsSaving(true);
    setSaveError(null);
    const {
      name
    } = newPolicy;
    const {
      error
    } = await (0, _http.addPolicy)(newPolicy);
    setIsSaving(false);
    if (error) {
      setSaveError(error);
    } else {
      history.push(encodeURI(`${_constants.BASE_PATH}/policies/${encodeURIComponent(name)}`));
    }
  };
  const onCancel = () => {
    history.push(`${_constants.BASE_PATH}/policies`);
  };
  const emptyPolicy = {
    name: '',
    snapshotName: '',
    schedule: _constants.DEFAULT_POLICY_SCHEDULE,
    repository: '',
    config: {},
    retention: {
      expireAfterValue: '',
      expireAfterUnit: _common.TIME_UNITS.DAY,
      maxCount: '',
      minCount: ''
    },
    isManagedPolicy: false
  };
  const renderSaveError = () => {
    return saveError ? /*#__PURE__*/_react.default.createElement(_shared_imports.SectionError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.addPolicy.savingPolicyErrorTitle",
        defaultMessage: "Cannot create new policy"
      }),
      error: saveError,
      "data-test-subj": "savePolicyApiError"
    }) : null;
  };
  const clearSaveError = () => {
    setSaveError(null);
  };
  if (isLoadingIndices) {
    return /*#__PURE__*/_react.default.createElement(_components.PageLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.addPolicy.loadingIndicesDescription",
      defaultMessage: "Loading available indices\u2026"
    }));
  }
  if (errorLoadingIndices) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.addPolicy.LoadingIndicesErrorMessage",
        defaultMessage: "Error loading available indices"
      }),
      error: errorLoadingIndices
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    restrictWidth: true,
    style: {
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "pageTitle"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.addPolicyTitle",
      defaultMessage: "Create policy"
    }))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_components.PolicyForm, {
    policy: emptyPolicy,
    indices: indices,
    dataStreams: dataStreams,
    currentUrl: pathname,
    isSaving: isSaving,
    saveError: renderSaveError(),
    clearSaveError: clearSaveError,
    onSave: onSave,
    onCancel: onCancel
  }));
};
exports.PolicyAdd = PolicyAdd;