"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../../constants");
var _app_context = require("../../../../app_context");
var _components = require("../../../../components");
var _navigation = require("../../../../services/navigation");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PolicyTable = ({
  policies,
  reload,
  openPolicyDetailsUrl,
  onPolicyDeleted,
  onPolicyExecuted
}) => {
  const {
    i18n,
    uiMetricService,
    history
  } = (0, _app_context.useServices)();
  const [selectedItems, setSelectedItems] = (0, _react.useState)([]);
  const columns = [{
    field: 'name',
    name: i18n.translate('xpack.snapshotRestore.policyList.table.policyNameColumnTitle', {
      defaultMessage: 'Policy'
    }),
    truncateText: true,
    sortable: true,
    render: (name, {
      inProgress,
      isManagedPolicy
    }) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(history, openPolicyDetailsUrl(name), () => uiMetricService.trackUiMetric(_constants.UIM_POLICY_SHOW_DETAILS_CLICK)), {
        "data-test-subj": "policyLink"
      }), name), ' '), isManagedPolicy ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.policyList.table.managedPolicyBadgeLabel",
          defaultMessage: "This is a managed policy"
        }),
        position: "right"
      })) : null, inProgress ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: i18n.translate('xpack.snapshotRestore.policyList.table.inProgressTooltip', {
          defaultMessage: 'Snapshot in progress'
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "m"
      }))) : null);
    }
  }, {
    field: 'snapshotName',
    name: i18n.translate('xpack.snapshotRestore.policyList.table.snapshotNameColumnTitle', {
      defaultMessage: 'Snapshot name'
    }),
    sortable: true,
    render: (snapshotName, {
      lastFailure,
      lastSuccess
    }) => {
      // Alert user if last snapshot failed
      if (lastSuccess && lastFailure && lastFailure.time > lastSuccess.time) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          alignItems: "center"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          position: "top",
          content: i18n.translate('xpack.snapshotRestore.policyList.table.lastSnapshotFailedTooltip', {
            defaultMessage: 'Last snapshot failed'
          })
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "warning",
          color: "danger"
        }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: 1
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s"
        }, snapshotName)));
      }
      return snapshotName;
    }
  }, {
    field: 'repository',
    name: i18n.translate('xpack.snapshotRestore.policyList.table.repositoryColumnTitle', {
      defaultMessage: 'Repository'
    }),
    truncateText: true,
    sortable: true
  }, {
    field: 'schedule',
    name: i18n.translate('xpack.snapshotRestore.policyList.table.scheduleColumnTitle', {
      defaultMessage: 'Schedule'
    }),
    truncateText: true,
    sortable: true
  }, {
    field: 'retention',
    name: i18n.translate('xpack.snapshotRestore.policyList.table.retentionColumnTitle', {
      defaultMessage: 'Retention'
    }),
    render: retention => retention ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "check",
      "aria-label": i18n.translate('xpack.snapshotRestore.policyList.table.retentionColumnAriaLabel', {
        defaultMessage: 'Retention configured'
      })
    }) : null
  }, {
    field: 'nextExecutionMillis',
    name: i18n.translate('xpack.snapshotRestore.policyList.table.nextExecutionColumnTitle', {
      defaultMessage: 'Next snapshot'
    }),
    truncateText: true,
    sortable: true,
    render: nextExecutionMillis => /*#__PURE__*/_react.default.createElement(_components.FormattedDateTime, {
      epochMs: nextExecutionMillis
    })
  }, {
    name: i18n.translate('xpack.snapshotRestore.policyList.table.actionsColumnTitle', {
      defaultMessage: 'Actions'
    }),
    actions: [{
      render: ({
        name,
        inProgress,
        isManagedPolicy
      }) => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_components.PolicyExecuteProvider, null, executePolicyPrompt => {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
            content: Boolean(inProgress) ? i18n.translate('xpack.snapshotRestore.policyList.table.actionExecuteDisabledTooltip', {
              defaultMessage: 'Policy is running'
            }) : i18n.translate('xpack.snapshotRestore.policyList.table.actionExecuteTooltip', {
              defaultMessage: 'Run now'
            })
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
            "aria-label": i18n.translate('xpack.snapshotRestore.policyList.table.actionExecuteAriaLabel', {
              defaultMessage: `Run ''{name}'' immediately`,
              values: {
                name
              }
            }),
            iconType: "play",
            color: "primary",
            "data-test-subj": "executePolicyButton",
            onClick: () => executePolicyPrompt(name, onPolicyExecuted),
            disabled: Boolean(inProgress)
          }));
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: i18n.translate('xpack.snapshotRestore.policyList.table.actionEditTooltip', {
            defaultMessage: 'Edit'
          })
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
          "aria-label": i18n.translate('xpack.snapshotRestore.policyList.table.actionEditAriaLabel', {
            defaultMessage: `Edit policy ''{name}''`,
            values: {
              name
            }
          }),
          iconType: "pencil",
          color: "primary"
        }, (0, _public.reactRouterNavigate)(history, (0, _navigation.linkToEditPolicy)(name)), {
          "data-test-subj": "editPolicyButton"
        })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_components.PolicyDeleteProvider, null, deletePolicyPrompt => {
          const label = !isManagedPolicy ? i18n.translate('xpack.snapshotRestore.policyList.table.actionDeleteTooltip', {
            defaultMessage: 'Delete'
          }) : i18n.translate('xpack.snapshotRestore.policyList.table.deleteManagedPolicyTableActionTooltip', {
            defaultMessage: 'You cannot delete a managed policy.'
          });
          return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
            content: label
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
            "aria-label": i18n.translate('xpack.snapshotRestore.policyList.table.actionDeleteAriaLabel', {
              defaultMessage: `Delete policy ''{name}''`,
              values: {
                name
              }
            }),
            iconType: "trash",
            color: "danger",
            "data-test-subj": "deletePolicyButton",
            onClick: () => deletePolicyPrompt([name], onPolicyDeleted),
            isDisabled: isManagedPolicy
          }));
        })));
      }
    }],
    width: '100px'
  }];
  const sorting = {
    sort: {
      field: 'name',
      direction: 'asc'
    }
  };
  const pagination = {
    initialPageSize: 20,
    pageSizeOptions: [10, 20, 50]
  };
  const selection = {
    onSelectionChange: newSelectedItems => setSelectedItems(newSelectedItems),
    selectable: ({
      isManagedPolicy
    }) => !isManagedPolicy,
    selectableMessage: selectable => {
      if (!selectable) {
        return i18n.translate('xpack.snapshotRestore.policyList.table.deleteManagedPolicySelectTooltip', {
          defaultMessage: 'You cannot delete a managed policy.'
        });
      }
      return '';
    }
  };
  const search = {
    toolsLeft: selectedItems.length ? /*#__PURE__*/_react.default.createElement(_components.PolicyDeleteProvider, null, deletePolicyPrompt => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: () => deletePolicyPrompt(selectedItems.map(({
          name
        }) => name), onPolicyDeleted),
        color: "danger",
        "data-test-subj": "srPolicyListBulkDeleteActionButton"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.policyList.table.deletePolicyButton",
        defaultMessage: "Delete {count, plural, one {policy} other {policies}}",
        values: {
          count: selectedItems.length
        }
      }));
    }) : undefined,
    toolsRight: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      key: "reloadPolicies",
      color: "success",
      iconType: "refresh",
      onClick: reload,
      "data-test-subj": "reloadButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyList.table.reloadPoliciesButton",
      defaultMessage: "Reload"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
      key: "createNewPolicy"
    }, (0, _public.reactRouterNavigate)(history, (0, _navigation.linkToAddPolicy)()), {
      fill: true,
      iconType: "plusInCircle",
      "data-test-subj": "createPolicyButton"
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyList.table.addPolicyButton",
      defaultMessage: "Create policy"
    }))],
    box: {
      incremental: true,
      schema: true
    },
    filters: [{
      type: 'field_value_selection',
      field: 'repository',
      name: i18n.translate('xpack.snapshotRestore.policyList.table.repositoryFilterLabel', {
        defaultMessage: 'Repository'
      }),
      multiSelect: false,
      options: Object.keys(policies.reduce((repositoriesMap, policy) => {
        repositoriesMap[policy.repository] = true;
        return repositoriesMap;
      }, {})).map(repository => {
        return {
          value: repository,
          view: repository
        };
      })
    }]
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    className: "snapshotRestore__policyTable",
    items: policies,
    itemId: "name",
    columns: columns,
    search: search,
    sorting: sorting,
    selection: selection,
    pagination: pagination,
    rowProps: () => ({
      'data-test-subj': 'row'
    }),
    cellProps: () => ({
      'data-test-subj': 'cell'
    }),
    "data-test-subj": "policyTable"
  });
};
exports.PolicyTable = PolicyTable;